/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.ShowAllAffectedGenericAction;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.idea.svn.SvnDiffProvider;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.annotate.BaseSvnFileAnnotation;

public class SvnFileAnnotation
extends BaseSvnFileAnnotation {
    private final VirtualFile myFile;

    public SvnFileAnnotation(SvnVcs vcs, VirtualFile file, String contents, VcsRevisionNumber baseRevision) {
        super(vcs, contents, baseRevision);
        this.myFile = file;
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    protected void showAllAffectedPaths(SvnRevisionNumber number) {
        ShowAllAffectedGenericAction.showSubmittedFiles((Project)this.myVcs.getProject(), (VcsRevisionNumber)number, (VirtualFile)this.myFile, (VcsKey)this.myVcs.getKeyInstanceMethod());
    }

    public boolean isBaseRevisionChanged(VcsRevisionNumber number) {
        VcsRevisionDescription description = ((SvnDiffProvider)this.myVcs.getDiffProvider()).getCurrentRevisionDescription(this.myFile);
        return description != null && !description.getRevisionNumber().equals(this.myBaseRevision);
    }
}

