/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.debug;

import com.sun.jdi.VMOutOfMemoryException;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.CallSite;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.jpda.DebuggerStartException;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.execute.ExecutionContext;
import org.netbeans.modules.maven.api.execute.ExecutionResultChecker;
import org.netbeans.modules.maven.api.execute.LateBoundPrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.PrerequisitesChecker;
import org.netbeans.modules.maven.api.execute.RunConfig;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.debug.MavenJPDAStart;
import org.netbeans.modules.maven.execute.AbstractMavenExecutor;
import org.netbeans.modules.maven.execute.OutputTabMaintainer;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.NbCollections;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class DebuggerChecker
implements LateBoundPrerequisitesChecker,
ExecutionResultChecker,
PrerequisitesChecker {
    private static final String ARGLINE = "argLine";
    private static final String MAVENSUREFIREDEBUG = "maven.surefire.debug";
    private static final Logger LOGGER = Logger.getLogger(DebuggerChecker.class.getName());
    private DebuggerTabMaintainer tabMaintainer;

    @Override
    public boolean checkRunConfig(final RunConfig config) {
        String cname;
        if (config.getProject() == null) {
            return true;
        }
        if ("debug.fix".equals(config.getActionName()) && RunUtils.isCompileOnSaveEnabled(config) && (cname = config.getProperties().get("jpda.stopclass")) != null) {
            Set mods = DataObject.getRegistry().getModifiedSet();
            if (!mods.isEmpty()) {
                ClassPath[] cps = ((ProjectSourcesClassPathProvider)config.getProject().getLookup().lookup(ProjectSourcesClassPathProvider.class)).getProjectClassPaths("classpath/source");
                final HashSet<URL> urls = new HashSet<URL>();
                for (DataObject mod : mods) {
                    for (ClassPath cp : cps) {
                        FileObject root;
                        if (!cp.contains(mod.getPrimaryFile()) || (root = cp.findOwnerRoot(mod.getPrimaryFile())) == null) continue;
                        urls.add(root.toURL());
                    }
                }
                LifecycleManager.getDefault().saveAll();
                if (!urls.isEmpty()) {
                    final int count = urls.size();
                    BuildArtifactMapper.ArtifactsUpdated listener = new BuildArtifactMapper.ArtifactsUpdated(){
                        private int countdown;
                        final /* synthetic */ DebuggerChecker this$0;
                        {
                            this.this$0 = this$0;
                            this.countdown = count;
                        }

                        public void artifactsUpdated(Iterable<File> artifacts) {
                            if (this.countdown > 0) {
                                --this.countdown;
                            } else {
                                for (URL url : urls) {
                                    BuildArtifactMapper.removeArtifactsUpdatedListener((URL)url, (BuildArtifactMapper.ArtifactsUpdated)this);
                                }
                                this.this$0.doReload(config, cname);
                            }
                        }
                    };
                    for (URL url : urls) {
                        BuildArtifactMapper.addArtifactsUpdatedListener((URL)url, (BuildArtifactMapper.ArtifactsUpdated)listener);
                    }
                } else {
                    this.doReload(config, cname);
                }
            } else {
                this.doReload(config, cname);
            }
            return false;
        }
        boolean debug = "true".equalsIgnoreCase(config.getProperties().get("jpda.listen"));
        if (debug && "debug.test.single".equalsIgnoreCase(config.getActionName()) && config.getGoals().contains("surefire:test")) {
            String newArgs = config.getProperties().get(MAVENSUREFIREDEBUG);
            Object oldArgs = config.getProperties().get(ARGLINE);
            String ver = PluginPropertyUtils.getPluginVersion(config.getMavenProject(), "org.apache.maven.plugins", "maven-surefire-plugin");
            if (ver == null) {
                ver = "2.4";
            }
            DefaultArtifactVersion twopointfour = new DefaultArtifactVersion("2.4");
            DefaultArtifactVersion current = new DefaultArtifactVersion(ver);
            int compare = current.compareTo((Object)twopointfour);
            if (oldArgs != null && newArgs == null && compare >= 0) {
                config.setProperty(MAVENSUREFIREDEBUG, (String)oldArgs);
                config.setProperty(ARGLINE, null);
            }
            if (newArgs != null && compare < 0) {
                oldArgs = (String)(oldArgs == null ? "" : oldArgs) + " " + newArgs;
                config.setProperty(ARGLINE, (String)oldArgs);
                config.setProperty(MAVENSUREFIREDEBUG, null);
            }
        }
        if ("true".equals(config.getProperties().get("jpda.attach"))) {
            try (ServerSocket ss = new ServerSocket();){
                ss.bind(null);
                int port = ss.getLocalPort();
                InetAddress addr = ss.getInetAddress();
                String address = addr.isAnyLocalAddress() ? "localhost" : addr.getHostAddress();
                config.setProperty("jpda.attach", address + ":" + port);
                config.setProperty("jpda.attach.address", address);
                config.setProperty("jpda.attach.port", "" + port);
            }
            catch (IOException ex) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReload(RunConfig config, String cname) {
        DebuggerTabMaintainer otm = this.getOutputTabMaintainer(config.getExecutionName());
        InputOutput io = otm.getInputOutput();
        io.select();
        OutputWriter ow = io.getOut();
        try {
            ow.reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.reload(config.getProject(), ow, cname);
        }
        finally {
            io.getOut().close();
            otm.markTab();
        }
    }

    @Override
    public boolean checkRunConfig(RunConfig config, ExecutionContext context) {
        if (config.getProject() == null) {
            return true;
        }
        boolean debug = "true".equalsIgnoreCase(config.getProperties().get("jpda.listen"));
        boolean mavenDebug = "maven".equalsIgnoreCase(config.getProperties().get("jpda.listen"));
        if (debug || mavenDebug) {
            String key = "Env.MAVEN_OPTS";
            if (mavenDebug) {
                String vmargs = "-agentlib:jdwp=transport=dt_socket,server=n,address=${jpda.address}";
                String orig = config.getProperties().get(key);
                if (orig == null) {
                    orig = System.getenv("MAVEN_OPTS");
                }
                config.setProperty(key, (String)(orig != null ? orig + " " + vmargs : vmargs));
            }
            try {
                ClassPath addCP;
                Project p = config.getProject();
                NbMavenProject prj = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
                MavenJPDAStart start = (MavenJPDAStart)p.getLookup().lookup(MavenJPDAStart.class);
                start.setName(prj.getMavenProject().getArtifactId());
                String stopClass = config.getProperties().get("jpda.stopclass");
                if (stopClass == null) {
                    stopClass = (String)config.getInternalProperties().get("jpda.stopclass");
                }
                start.setStopClassName(stopClass);
                String sm = (String)config.getInternalProperties().get("jpda.stopmethod");
                if (sm != null) {
                    start.setStopMethod(sm);
                }
                if ((addCP = (ClassPath)config.getInternalProperties().get("jpda.additionalClasspath")) != null) {
                    start.setAdditionalSourcePath(addCP);
                }
                String val = start.execute(context.getInputOutput());
                for (Map.Entry entry : NbCollections.checkedMapByFilter(config.getProperties(), String.class, String.class, (boolean)true).entrySet()) {
                    String address;
                    String value = (String)entry.getValue();
                    StringBuilder buf = null;
                    String replaceItem = "${jpda.address}";
                    int index = value.indexOf(replaceItem);
                    while (index > -1) {
                        String newItem = val;
                        String string = newItem = newItem == null ? "" : newItem;
                        if (buf == null) {
                            buf = new StringBuilder(value);
                        }
                        buf.replace(index, index + replaceItem.length(), newItem);
                        index = buf.indexOf(replaceItem);
                    }
                    if (((String)entry.getKey()).equals(MAVENSUREFIREDEBUG) && (index = value.indexOf(address = "address=")) > -1) {
                        if (buf == null) {
                            buf = new StringBuilder(value);
                        }
                        buf.replace(index + 8, buf.length(), val);
                    }
                    if (buf != null) {
                        value = buf.toString();
                    }
                    config.setProperty((String)entry.getKey(), value);
                }
                config.setProperty("jpda.address", val);
            }
            catch (Throwable th) {
                LOGGER.log(Level.INFO, th.getMessage(), th);
            }
        }
        if ("debug.stepinto".equals(config.getActionName())) {
            // empty if block
        }
        return true;
    }

    @Override
    public void executionResult(RunConfig config, ExecutionContext res, int resultCode) {
        if (config.getProject() != null && resultCode == 0 && "debug.fix".equals(config.getActionName())) {
            String cname = config.getProperties().get("jpda.stopclass");
            if (cname != null) {
                this.reload(config.getProject(), res.getInputOutput().getOut(), cname);
            } else {
                res.getInputOutput().getErr().println("Missing jpda.stopclass property in action mapping definition. Cannot reload class.");
            }
        }
        if (resultCode == 0 && config.getProperties().get("jpda.attach.trigger") == null) {
            try {
                DebuggerChecker.connect(config);
            }
            catch (DebuggerStartException ex) {
                ex.printStackTrace((PrintWriter)res.getInputOutput().getErr());
            }
        }
    }

    static void connect(RunConfig config) throws DebuggerStartException {
        String attachToAddress = config.getProperties().get("jpda.attach");
        if (attachToAddress != null) {
            String transport = config.getProperties().get("jpda.attach.transport");
            if (transport == null || "dt_socket".equals(transport)) {
                int port;
                int colon = attachToAddress.indexOf(58);
                try {
                    port = Integer.parseInt(attachToAddress.substring(colon + 1));
                }
                catch (NumberFormatException ex) {
                    DebuggerStartException debugEx = new DebuggerStartException("Cannot parse " + attachToAddress.substring(colon + 1) + " as number");
                    debugEx.initCause((Throwable)ex);
                    throw debugEx;
                }
                String host = colon > 0 ? attachToAddress.substring(0, colon) : "localhost";
                JPDADebugger.attach((String)host, (int)port, (Object[])new Object[0]);
            } else if ("dt_shmem".equals(transport)) {
                JPDADebugger.attach((String)attachToAddress, (Object[])new Object[0]);
            } else {
                LOGGER.log(Level.INFO, "Ignoring unknown transport '" + transport + "'");
            }
        }
    }

    public void reload(Project project, OutputWriter logger, String classname) {
        ClassPath cp;
        DebuggerEngine debuggerEngine = DebuggerManager.getDebuggerManager().getCurrentEngine();
        if (debuggerEngine == null) {
            logger.println("No debugging sessions was found.");
            return;
        }
        JPDADebugger debugger = (JPDADebugger)debuggerEngine.lookupFirst(null, JPDADebugger.class);
        if (debugger == null) {
            logger.println("Current debugger is not JPDA one.");
            return;
        }
        if (!debugger.canFixClasses()) {
            logger.println("The debugger does not support Fix action.");
            return;
        }
        if (debugger.getState() == 4) {
            logger.println("The debugger is not running");
            return;
        }
        HashMap<CallSite, byte[]> map = new HashMap<CallSite, byte[]>();
        EditorContext editorContext = (EditorContext)DebuggerManager.getDebuggerManager().lookupFirst(null, EditorContext.class);
        String clazz = classname.replace('.', '/') + ".class";
        ProjectSourcesClassPathProvider prv = (ProjectSourcesClassPathProvider)project.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        ClassPath[] ccp = prv.getProjectClassPaths("classpath/compile");
        FileObject fo2 = null;
        ClassPath[] classPathArray = ccp;
        int n = classPathArray.length;
        for (int i = 0; i < n && (fo2 = (cp = classPathArray[i]).findResource(clazz)) == null; ++i) {
        }
        if (fo2 != null) {
            try {
                String basename = fo2.getName();
                for (FileObject classfile : fo2.getParent().getChildren()) {
                    String basename2 = classfile.getName();
                    if (!"class".equals(classfile.getExt()) || !basename2.equals(basename) && !basename2.startsWith(basename + "$")) continue;
                    String url = this.classToSourceURL(classfile, logger);
                    if (url != null) {
                        editorContext.updateTimeStamp((Object)debugger, url);
                    }
                    map.put((CallSite)((Object)(classname + basename2.substring(basename.length()))), classfile.asBytes());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (map.isEmpty()) {
            logger.println("No class to reload");
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Classes to reload:\n");
        for (String c : map.keySet()) {
            sb.append(" ");
            sb.append(c);
            sb.append("\n");
        }
        logger.println((Object)sb);
        Object error = null;
        try {
            debugger.fixClasses(map);
        }
        catch (UnsupportedOperationException uoex) {
            error = "The virtual machine does not support this operation: " + uoex.getLocalizedMessage();
        }
        catch (NoClassDefFoundError ncdfex) {
            error = "The bytes don't correspond to the class type (the names don't match): " + ncdfex.getLocalizedMessage();
        }
        catch (VerifyError ver) {
            error = "A \"verifier\" detects that a class, though well formed, contains an internal inconsistency or security problem: " + ver.getLocalizedMessage();
        }
        catch (UnsupportedClassVersionError ucver) {
            error = "The major and minor version numbers in bytes are not supported by the VM. " + ucver.getLocalizedMessage();
        }
        catch (ClassFormatError cfer) {
            error = "The bytes do not represent a valid class. " + cfer.getLocalizedMessage();
            LOGGER.log(Level.INFO, (String)error, cfer);
        }
        catch (ClassCircularityError ccer) {
            error = "A circularity has been detected while initializing a class: " + ccer.getLocalizedMessage();
        }
        catch (VMOutOfMemoryException oomex) {
            error = "Out of memory in the target VM has occurred during class reload.";
        }
        if (error != null) {
            logger.println((String)error);
        } else {
            logger.println("Code updated");
        }
    }

    private String classToSourceURL(FileObject fo, OutputWriter logger) {
        FileObject[] sRoots;
        ClassPath sourcePath;
        FileObject rfo;
        ClassPath cp = ClassPath.getClassPath((FileObject)fo, (String)"classpath/execute");
        if (cp == null) {
            return null;
        }
        FileObject root = cp.findOwnerRoot(fo);
        String resourceName = cp.getResourceName(fo, '/', false);
        if (resourceName == null) {
            logger.println("Can not find classpath resource for " + String.valueOf(fo) + ", skipping...");
            return null;
        }
        int i = resourceName.indexOf(36);
        if (i > 0) {
            resourceName = resourceName.substring(0, i);
        }
        if ((rfo = (sourcePath = ClassPathSupport.createClassPath((FileObject[])(sRoots = SourceForBinaryQuery.findSourceRoots((URL)root.toURL()).getRoots()))).findResource(resourceName + ".java")) == null) {
            return null;
        }
        return rfo.toURL().toExternalForm();
    }

    private synchronized DebuggerTabMaintainer getOutputTabMaintainer(String name) {
        if (this.tabMaintainer == null) {
            this.tabMaintainer = new DebuggerTabMaintainer(name);
        }
        return this.tabMaintainer;
    }

    private static class DebuggerTabMaintainer
    extends OutputTabMaintainer<TabCtx> {
        private TabCtx tabContext = new TabCtx();

        public DebuggerTabMaintainer(String name) {
            super(name);
        }

        @Override
        protected Class<TabCtx> tabContextType() {
            return TabCtx.class;
        }

        @Override
        protected TabCtx createContext() {
            return this.tabContext.clone();
        }

        @Override
        protected void reassignAdditionalContext(TabCtx tabContext) {
            this.tabContext = tabContext;
        }

        @Override
        protected Action[] createNewTabActions() {
            this.tabContext.options = new AbstractMavenExecutor.OptionsAction();
            return new Action[]{this.tabContext.options};
        }

        void markTab() {
            this.markFreeTab();
        }
    }

    private static class TabCtx {
        AbstractMavenExecutor.OptionsAction options;

        private TabCtx() {
        }

        protected TabCtx clone() {
            TabCtx c = new TabCtx();
            c.options = this.options;
            return c;
        }
    }
}

