/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Future;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.lsp.server.LspServerState;
import org.netbeans.modules.java.lsp.server.URITranslator;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.spi.indexing.ErrorsCache;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public final class ErrorsNotifier {
    private final Map<LspServerState, Future<Void>> servers = new WeakHashMap<LspServerState, Future<Void>>();
    private final Map<URL, Collection<? extends URL>> lastFilesWithErrors = new HashMap<URL, Collection<? extends URL>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(LspServerState server, Future<Void> future) {
        Map<LspServerState, Future<Void>> map = this.servers;
        synchronized (map) {
            this.servers.put(server, future);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyErrors(URL root) {
        ArrayList<LspServerState> toRemove = new ArrayList<LspServerState>();
        ArrayList<LspServerState> toProcess = new ArrayList<LspServerState>();
        Map<LspServerState, Future<Void>> map = this.servers;
        synchronized (map) {
            for (Map.Entry<LspServerState, Future<Void>> entry : this.servers.entrySet()) {
                if (entry.getValue().isDone()) {
                    toRemove.add(entry.getKey());
                    continue;
                }
                toProcess.add(entry.getKey());
            }
            this.servers.keySet().removeAll(toRemove);
        }
        try {
            Collection last = this.lastFilesWithErrors.getOrDefault(root, Collections.emptyList());
            Collection filesWithErrors = ErrorsCache.getAllFilesWithRecord((URL)root);
            if (filesWithErrors.isEmpty()) {
                this.lastFilesWithErrors.remove(root);
            } else {
                this.lastFilesWithErrors.put(root, new ArrayList(filesWithErrors));
                last.removeAll(filesWithErrors);
            }
            if (!filesWithErrors.isEmpty() || !last.isEmpty()) {
                Project project = FileOwnerQuery.getOwner((URI)root.toURI());
                boolean inOpenedProject = false;
                for (LspServerState server : toProcess) {
                    for (Project p : server.openedProjects().getNow(new Project[0])) {
                        FileObject fo;
                        if (p != project) continue;
                        inOpenedProject = true;
                        for (URL fileWithError : filesWithErrors) {
                            List diags;
                            fo = URLMapper.findFileObject((URL)fileWithError);
                            if (fo == null || (diags = ErrorsCache.getErrors((FileObject)fo, (kind, range, message) -> {
                                Position start = new Position(range.start().line() - 1, range.start().column() - 1);
                                Position end = range.end() != null ? new Position(range.end().line() - 1, range.end().column() - 1) : start;
                                Diagnostic d = new Diagnostic(new Range(start, end), message);
                                d.setSeverity(kind == ErrorsCache.ErrorKind.WARNING ? DiagnosticSeverity.Warning : DiagnosticSeverity.Error);
                                return d;
                            })).isEmpty()) continue;
                            String lspUri = URITranslator.getDefault().uriToLSP(fileWithError.toURI().toString());
                            ((TextDocumentServiceImpl)server.getTextDocumentService()).publishDiagnostics(lspUri, diags);
                        }
                        for (URL fileWithError : last) {
                            fo = URLMapper.findFileObject((URL)fileWithError);
                            if (fo == null) continue;
                            String lspUri = URITranslator.getDefault().uriToLSP(fileWithError.toURI().toString());
                            ((TextDocumentServiceImpl)server.getTextDocumentService()).publishDiagnostics(lspUri, Collections.emptyList());
                        }
                    }
                }
                if (!inOpenedProject) {
                    this.lastFilesWithErrors.remove(root);
                }
            }
        }
        catch (IOException | URISyntaxException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

