/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.protocol;

import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.eclipse.lsp4j.ApplyWorkspaceEditParams;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.editor.codegen.GeneratorUtils;
import org.netbeans.modules.java.lsp.server.Utils;
import org.netbeans.modules.java.lsp.server.protocol.CodeActionsProvider;
import org.netbeans.modules.java.lsp.server.protocol.NbCodeLanguageClient;
import org.netbeans.modules.java.lsp.server.protocol.TextDocumentServiceImpl;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.openide.filesystems.FileObject;

public final class ImplementAllAbstractMethodsAction
extends CodeActionsProvider {
    private static final String IMPLEMENT_ALL_ABSTRACT_METHODS = "nbls.java.implement.all.abstract.methods";
    private final Gson gson = new Gson();

    @Override
    public List<CodeAction> getCodeActions(NbCodeLanguageClient client, ResultIterator resultIterator, CodeActionParams params) throws Exception {
        return Collections.emptyList();
    }

    @Override
    public Set<String> getCommands() {
        return Collections.singleton(IMPLEMENT_ALL_ABSTRACT_METHODS);
    }

    @Override
    public CompletableFuture<Object> processCommand(NbCodeLanguageClient client, String command, List<Object> arguments) {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        try {
            JavaSource js;
            String uri;
            if (arguments.size() >= 2) {
                uri = ((JsonPrimitive)arguments.get(0)).getAsString();
                FileObject file = Utils.fromUri(uri);
                js = JavaSource.forFileObject((FileObject)file);
                if (js == null) {
                    throw new IOException("Cannot get JavaSource for: " + uri);
                }
            } else {
                throw new IllegalArgumentException(String.format("Illegal number of arguments received for command: %s", command));
            }
            Position position = (Position)this.gson.fromJson(this.gson.toJson(arguments.get(1)), Position.class);
            List<TextEdit> edits = TextDocumentServiceImpl.modify2TextEdits(js, (Task<WorkingCopy>)((Task)wc -> {
                wc.toPhase(JavaSource.Phase.RESOLVED);
                Document doc = wc.getSnapshot().getSource().getDocument(true);
                if (doc instanceof StyledDocument) {
                    int offset = Utils.getOffset((StyledDocument)doc, position);
                    GeneratorUtils.generateAllAbstractMethodImplementations((WorkingCopy)wc, (TreePath)wc.getTreeUtilities().pathFor(offset));
                }
            }));
            client.applyEdit(new ApplyWorkspaceEditParams(new WorkspaceEdit(Collections.singletonMap(uri, edits))));
            future.complete(true);
        }
        catch (IOException | IllegalArgumentException ex) {
            future.completeExceptionally(ex);
        }
        return future;
    }
}

