/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.security.core.xenc;

import com.sun.xml.ws.security.opt.impl.enc.CryptoProcessor;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataHandler;
import javax.activation.MailcapCommandMap;
import javax.xml.bind.annotation.adapters.XmlAdapter;

public class CVAdapter
extends XmlAdapter<DataHandler, byte[]> {
    public static final String MIME_CIPHERVALUE = "application/ciphervalue";
    public static final String CV_HANDLER_CLASS = "com.sun.xml.ws.security.opt.impl.util.CVDataHandler";
    private CryptoProcessor cp;

    public CVAdapter() {
        this.ensureHandlerRegistered();
    }

    public CVAdapter(CryptoProcessor cp) {
        this();
        this.cp = cp;
    }

    @Override
    public DataHandler marshal(byte[] value) {
        return new DataHandler(this.cp, MIME_CIPHERVALUE);
    }

    @Override
    public byte[] unmarshal(DataHandler dh) {
        throw new UnsupportedOperationException();
    }

    private void ensureHandlerRegistered() {
        CommandMap map = CommandMap.getDefaultCommandMap();
        CommandInfo[] commands = map.getAllCommands(MIME_CIPHERVALUE);
        if (commands != null && commands.length > 0) {
            for (CommandInfo command : commands) {
                if (!CV_HANDLER_CLASS.equals(command.getCommandClass())) continue;
                return;
            }
        }
        if (map instanceof MailcapCommandMap) {
            ((MailcapCommandMap)map).addMailcap("application/ciphervalue;;x-java-content-handler=com.sun.xml.ws.security.opt.impl.util.CVDataHandler");
        }
    }
}

