/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.queries;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.queries.JavadocForBinaryQuery;
import org.netbeans.modules.java.api.common.impl.MultiModule;
import org.netbeans.spi.java.queries.JavadocForBinaryQueryImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

final class MultiModuleJavadocForBinaryQueryImpl
implements JavadocForBinaryQueryImplementation,
PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MultiModuleJavadocForBinaryQueryImpl.class.getName());
    private final AntProjectHelper helper;
    private final PropertyEvaluator evaluator;
    private final MultiModule modules;
    private final String[] binaryProperties;
    private final String javadocProperty;
    private final ConcurrentMap<URI, R> cache;

    public MultiModuleJavadocForBinaryQueryImpl(@NonNull AntProjectHelper helper, @NonNull PropertyEvaluator evaluator, @NonNull MultiModule modules, @NonNull String[] binaryProperties, @NonNull String javadocProperty) {
        Parameters.notNull((CharSequence)"helper", (Object)helper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"modules", (Object)modules);
        Parameters.notNull((CharSequence)"binaryProperties", (Object)binaryProperties);
        Parameters.notNull((CharSequence)"javadocProperty", (Object)javadocProperty);
        this.helper = helper;
        this.evaluator = evaluator;
        this.modules = modules;
        this.binaryProperties = binaryProperties;
        this.javadocProperty = javadocProperty;
        this.cache = new ConcurrentHashMap<URI, R>();
        this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.evaluator));
        this.modules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.modules));
    }

    public JavadocForBinaryQuery.Result findJavadoc(URL binaryRoot) {
        boolean archive = false;
        if (FileUtil.isArchiveArtifact((URL)binaryRoot)) {
            binaryRoot = FileUtil.getArchiveFile((URL)binaryRoot);
            archive = true;
        }
        R res = null;
        try {
            URI artefact = binaryRoot.toURI();
            res = (R)this.cache.get(artefact);
            if (res == null) {
                res = this.createResult(artefact, archive, this.modules, this.binaryProperties);
                R prev = (R)this.cache.get(artefact);
                if (prev != null) {
                    res = prev;
                } else if (res != null && (prev = this.cache.putIfAbsent(artefact, res)) != null) {
                    res = prev;
                }
            }
        }
        catch (URISyntaxException e) {
            LOG.log(Level.WARNING, "Invalid URI: {0}", binaryRoot.toExternalForm());
        }
        return res;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block3: {
            String propName;
            block2: {
                Object source = evt.getSource();
                propName = evt.getPropertyName();
                if (source != this.modules) break block2;
                Collection<? extends String> moduleNames = this.modules.getModuleNames();
                Iterator it = this.cache.entrySet().iterator();
                while (it.hasNext()) {
                    R r = (R)it.next().getValue();
                    if (moduleNames.contains(r.getModuleName())) continue;
                    it.remove();
                }
                break block3;
            }
            if (!MultiModuleJavadocForBinaryQueryImpl.contains(propName, this.binaryProperties)) break block3;
            Iterator it = this.cache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                URI uri = (URI)e.getKey();
                R r = (R)e.getValue();
                if (!propName.equals(r.getProperty()) || MultiModuleJavadocForBinaryQueryImpl.getOwner(this.evaluator, this.helper, uri, new String[]{propName}) != null) continue;
                it.remove();
            }
        }
    }

    @CheckForNull
    private R createResult(@NonNull URI artefact, boolean archive, @NonNull MultiModule modules, String ... properties) {
        String moduleName;
        String prop = MultiModuleJavadocForBinaryQueryImpl.getOwner(this.evaluator, this.helper, artefact, properties);
        if (prop != null && (moduleName = MultiModuleJavadocForBinaryQueryImpl.getModuleName(artefact, archive)) != null && modules.getModuleNames().contains(moduleName)) {
            return new R(artefact, this.javadocProperty, modules, this.evaluator, this.helper, moduleName, prop);
        }
        return null;
    }

    private static boolean contains(@NonNull String prop, String ... props) {
        for (String p : props) {
            if (!p.equals(prop)) continue;
            return true;
        }
        return false;
    }

    @CheckForNull
    private static String getOwner(@NonNull PropertyEvaluator eval, @NonNull AntProjectHelper helper, @NonNull URI artefact, @NonNull String[] properties) {
        return Arrays.stream(properties).map(prop -> {
            String val = eval.getProperty(prop);
            return val == null ? null : Pair.of((Object)prop, (Object)val);
        }).filter(propPathPair -> propPathPair != null).map(propPathPair -> {
            try {
                File f = helper.resolveFile((String)propPathPair.second());
                URI uri = BaseUtilities.toURI((File)f);
                String suri = uri.toString();
                if (!suri.endsWith("/")) {
                    uri = new URI(suri + '/');
                }
                return Pair.of((Object)((String)propPathPair.first()), (Object)uri);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }).filter(propFolderURIPair -> propFolderURIPair != null && artefact.toString().startsWith(((URI)propFolderURIPair.second()).toString())).map(propFolderURIPair -> (String)propFolderURIPair.first()).findAny().orElse(null);
    }

    @CheckForNull
    private static String getModuleName(@NonNull URI artefact, boolean archive) {
        Path p = Paths.get(artefact);
        if (p == null) {
            return null;
        }
        String nameExt = p.getFileName().toString();
        int dot = nameExt.lastIndexOf(46);
        if (dot < 0 || !archive) {
            return nameExt;
        }
        if (dot == 0) {
            return null;
        }
        return nameExt.substring(0, dot);
    }

    private static final class R
    implements JavadocForBinaryQuery.Result,
    PropertyChangeListener {
        private static final URL[] EMPTY = new URL[0];
        private final URI artefact;
        private final String jdocProperty;
        private final MultiModule modules;
        private final PropertyEvaluator evaluator;
        private final AntProjectHelper helper;
        private final String moduleName;
        private final String prop;
        private final ChangeSupport listeners;
        private final AtomicReference<URL[]> cache;
        private final AtomicBoolean currentModuleExists;

        R(@NonNull URI artefact, @NonNull String jdocProperty, @NonNull MultiModule modules, @NonNull PropertyEvaluator evaluator, @NonNull AntProjectHelper helper, @NonNull String moduleName, @NonNull String prop) {
            Parameters.notNull((CharSequence)"artefact", (Object)artefact);
            Parameters.notNull((CharSequence)"jdocProperty", (Object)jdocProperty);
            Parameters.notNull((CharSequence)"modules", (Object)modules);
            Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
            Parameters.notNull((CharSequence)"helper", (Object)helper);
            Parameters.notNull((CharSequence)"moduleName", (Object)moduleName);
            Parameters.notNull((CharSequence)"prop", (Object)prop);
            this.artefact = artefact;
            this.jdocProperty = jdocProperty;
            this.modules = modules;
            this.evaluator = evaluator;
            this.helper = helper;
            this.moduleName = moduleName;
            this.prop = prop;
            this.listeners = new ChangeSupport((Object)this);
            this.cache = new AtomicReference();
            this.currentModuleExists = new AtomicBoolean(true);
            this.modules.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.modules));
            this.evaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.evaluator));
        }

        /*
         * Exception decompiling
         */
        public URL[] getRoots() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * java.lang.UnsupportedOperationException
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
             *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void addChangeListener(@NonNull ChangeListener l) {
            this.listeners.addChangeListener(l);
        }

        public void removeChangeListener(@NonNull ChangeListener l) {
            this.listeners.removeChangeListener(l);
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            Object source = evt.getSource();
            String propName = evt.getPropertyName();
            if (source == this.modules) {
                boolean exists = this.moduleExists();
                boolean fire = this.currentModuleExists.get() ^ exists;
                this.currentModuleExists.set(exists);
                if (fire) {
                    this.cache.set(null);
                    this.listeners.fireChange();
                }
            } else if (this.prop.equals(propName) || this.jdocProperty.equals(propName) || propName == null) {
                this.cache.set(null);
                this.listeners.fireChange();
            }
        }

        String getModuleName() {
            return this.moduleName;
        }

        String getProperty() {
            return this.prop;
        }

        private boolean moduleExists() {
            return this.modules.getModuleNames().contains(this.moduleName);
        }
    }
}

