/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.sql.support.SQLIdentifiers;
import org.openide.util.NbBundle;

public final class ConnectionProcessor
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ConnectionProcessor.class.getName());
    final BlockingQueue<Runnable> inqueue;
    private Connection conn;
    private SQLIdentifiers.Quoter quoter;
    private final AtomicReference<Thread> taskThreadRef = new AtomicReference();

    synchronized void setConnection(Connection conn) throws DatabaseException {
        this.conn = conn;
        this.setQuoter();
    }

    private synchronized void setQuoter() throws DatabaseException {
        try {
            this.quoter = this.conn != null && !this.conn.isClosed() ? SQLIdentifiers.createQuoter((DatabaseMetaData)this.conn.getMetaData()) : null;
        }
        catch (SQLException sqle) {
            throw new DatabaseException((Throwable)sqle);
        }
    }

    synchronized Connection getConnection() {
        return this.conn;
    }

    synchronized SQLIdentifiers.Quoter getQuoter() {
        return this.quoter;
    }

    synchronized void validateConnection() throws DatabaseException {
        try {
            if (this.conn == null) {
                return;
            }
            if (this.conn.isClosed()) {
                this.conn = null;
                throw new DatabaseException(NbBundle.getMessage(ConnectionProcessor.class, (String)"MSG_ConnectionLost"));
            }
            this.conn.getMetaData().getTables(null, null, " ", new String[]{"TABLE"}).close();
        }
        catch (SQLException e) {
            this.conn = null;
            LOGGER.log(Level.FINE, null, e);
            throw new DatabaseException(NbBundle.getMessage(ConnectionProcessor.class, (String)"MSG_ConnectionLost"), (Throwable)e);
        }
        finally {
            this.setQuoter();
        }
    }

    synchronized boolean isConnected() {
        return this.conn != null;
    }

    boolean isConnProcessorThread() {
        return Thread.currentThread().equals(this.taskThreadRef.get());
    }

    public ConnectionProcessor(BlockingQueue<Runnable> inqueue) {
        this.inqueue = inqueue;
    }

    @Override
    public void run() {
        if (this.taskThreadRef.getAndSet(Thread.currentThread()) != null) {
            throw new IllegalStateException("Run method called more than once on connection command processor");
        }
        try {
            while (true) {
                Runnable command = this.inqueue.take();
                command.run();
            }
        }
        catch (InterruptedException ie) {
            LOGGER.log(Level.INFO, null, ie);
            return;
        }
    }
}

