/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.api.output;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openide.filesystems.FileObject;

public final class Location {
    final String fileName;
    final String target;
    final String[] classNames;
    private Integer lineNum = null;
    private static final Pattern CALLSTACK_ITEM_PARSER = Pattern.compile("(.*)at (\\w[\\w\\.\\$<>]*)\\.(\\w+)\\((\\w+)\\.java\\:([0-9]+)\\)");

    public static Location parseLocation(String loc) {
        int extensionIndx;
        assert (loc != null);
        int targetDelimiterIndex = loc.lastIndexOf(58);
        if (targetDelimiterIndex == -1) {
            targetDelimiterIndex = loc.length();
        }
        if ((extensionIndx = loc.lastIndexOf(46, targetDelimiterIndex)) == -1) {
            extensionIndx = targetDelimiterIndex;
        }
        int packageSlashIndx = loc.lastIndexOf(47, extensionIndx - 1);
        String[] classNames = loc.substring(packageSlashIndx + 1, extensionIndx).split("\\$");
        String ext = loc.substring(extensionIndx, targetDelimiterIndex);
        String fileName = loc.substring(0, packageSlashIndx + 1) + classNames[0] + ext;
        String target = targetDelimiterIndex < loc.length() - 1 ? loc.substring(targetDelimiterIndex + 1) : null;
        return new Location(fileName, classNames, target);
    }

    @Deprecated
    public Location(String loc) {
        Location l = Location.parseLocation(loc);
        this.fileName = l.fileName;
        this.classNames = l.classNames;
        this.target = l.target;
        this.lineNum = l.lineNum;
    }

    @Deprecated
    public Location(String fileName, String target) {
        Location loc = Location.parseLocation(fileName + " : " + target);
        this.fileName = loc.fileName;
        this.classNames = loc.classNames;
        this.target = loc.target;
        this.lineNum = loc.lineNum;
    }

    private Location(String fileName, String[] classNames, String target) {
        this.fileName = fileName;
        this.target = target;
        this.classNames = classNames;
        try {
            this.lineNum = Integer.parseInt(target);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public Location withNoTarget() {
        return new Location(this.fileName, this.classNames, null);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTarget() {
        return this.target;
    }

    public Integer getLineNum() {
        return this.lineNum;
    }

    public boolean isLine() {
        return this.lineNum != null;
    }

    public boolean isMethod() {
        return this.target != null && this.lineNum == null;
    }

    String[] getClassNames() {
        return this.classNames;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fileName.substring(0, this.fileName.indexOf(this.classNames[0])));
        for (int i = 0; i < this.classNames.length; ++i) {
            String className = this.classNames[i];
            sb.append(className);
            sb.append("$");
        }
        sb.setLength(sb.length() - 1);
        sb.append(this.fileName.substring(this.fileName.indexOf(this.classNames[0]) + this.classNames[0].length()));
        if (this.target != null) {
            sb.append(":");
            sb.append(this.target);
        }
        return sb.toString();
    }

    public static final Location locationFromCallStackItem(String item) {
        Matcher m = CALLSTACK_ITEM_PARSER.matcher(item);
        if (m.matches()) {
            String pkg;
            StringBuilder ret = new StringBuilder(item.length());
            String className = m.group(2);
            String methodName = m.group(3);
            String fileNameBase = m.group(4);
            String line = m.group(5);
            int lastDot = className.lastIndexOf(46);
            String string = pkg = lastDot > 0 ? className.substring(0, lastDot) : "";
            if (fileNameBase != null) {
                ret.append(pkg.replace('.', '/')).append('/').append(fileNameBase);
            } else {
                ret.append(className.replace('.', '/'));
            }
            ret.append(".java");
            return Location.parseLocation(ret.toString() + ":" + line != null ? line : methodName);
        }
        return null;
    }

    public static interface Finder {
        public FileObject findFileObject(Location var1);
    }
}

