/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstBracketSuffix;
import com.sun.el.parser.AstDotSuffix;
import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.AstString;
import com.sun.el.parser.Node;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.StyledDocument;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.el.AstPath;
import org.netbeans.modules.web.el.spi.ELPlugin;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.el.spi.ResourceBundle;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Pair;
import org.openide.util.Parameters;
import org.openide.util.WeakListeners;

public final class ResourceBundles {
    private static final Logger LOGGER = Logger.getLogger(ResourceBundles.class.getName());
    protected static final Map<FileObject, ResourceBundles> CACHE = new WeakHashMap<FileObject, ResourceBundles>(1);
    private final WebModule webModule;
    private final Project project;
    private Map<String, ResourceBundleInfo> bundlesMap;
    private long currentBundlesHashCode;
    private final FileChangeListener FILE_CHANGE_LISTENER = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            super.fileChanged(fe);
            LOGGER.finer(String.format("File %s has changed.", fe.getFile()));
            ResourceBundles.this.resetResourceBundleMap();
        }
    };

    private ResourceBundles(WebModule webModule, Project project) {
        this.webModule = webModule;
        this.project = project;
    }

    public static ResourceBundles create(WebModule webModule, Project project) {
        return new ResourceBundles(webModule, project);
    }

    public static ResourceBundles get(FileObject fileObject) {
        Parameters.notNull((CharSequence)"fileObject", (Object)fileObject);
        if (CACHE.containsKey(fileObject)) {
            return CACHE.get(fileObject);
        }
        CACHE.clear();
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        ResourceBundles result = new ResourceBundles(webModule, owner);
        CACHE.put(fileObject, result);
        return result;
    }

    public boolean canHaveBundles() {
        return this.webModule != null && this.project != null;
    }

    public boolean isResourceBundleIdentifier(String identifier, ResolverContext context) {
        Parameters.notNull((CharSequence)"indentifier", (Object)identifier);
        Parameters.notNull((CharSequence)"context", (Object)context);
        for (ResourceBundle bundle : this.getBundles(context)) {
            if (!identifier.equals(bundle.getVar())) continue;
            return true;
        }
        return false;
    }

    public boolean isValidKey(String bundle, String key) {
        ResourceBundleInfo rbInfo = this.getBundleForIdentifier(bundle);
        if (rbInfo == null) {
            return true;
        }
        if (rbInfo.getResourceBundle().getKeys() == null) {
            return true;
        }
        return rbInfo.getResourceBundle().containsKey(key);
    }

    private ResourceBundleInfo getBundleForIdentifier(String ident) {
        for (Map.Entry<String, ResourceBundleInfo> entry : this.getBundlesMap().entrySet()) {
            if (!ident.equals(entry.getValue().getVarName())) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<Location> getLocationsForBundleIdent(String ident) {
        ResourceBundleInfo rbi = this.getBundleForIdentifier(ident);
        if (rbi == null) {
            return Collections.emptyList();
        }
        ArrayList<Location> locations = new ArrayList<Location>(rbi.getFiles().size());
        for (FileObject fileObject : rbi.getFiles()) {
            locations.add(new Location(0, fileObject));
        }
        return locations;
    }

    public List<Location> getLocationsForBundleKey(String ident, String key) {
        ArrayList<Location> locations = new ArrayList<Location>();
        for (Location location : this.getLocationsForBundleIdent(ident)) {
            try {
                LineCookie lc;
                DataObject dobj = DataObject.find((FileObject)location.getFile());
                EditorCookie ec = (EditorCookie)dobj.getLookup().lookup(EditorCookie.class);
                try {
                    ec.openDocument();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if ((lc = (LineCookie)dobj.getLookup().lookup(LineCookie.class)) == null) continue;
                Line.Set ls = lc.getLineSet();
                for (Line line : ls.getLines()) {
                    if (!line.getText().contains(key + "=") && !line.getText().contains(key + " =")) continue;
                    try {
                        StyledDocument document = ec.getDocument();
                        int offset = document.getText(0, document.getLength()).indexOf(line.getText());
                        locations.add(new Location(offset, location.getFile()));
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return locations;
    }

    public List<Pair<AstIdentifier, Node>> collectKeys(Node root) {
        return this.collectKeys(root, new ResolverContext());
    }

    public List<Pair<AstIdentifier, Node>> collectKeys(Node root, ResolverContext context) {
        ArrayList<Pair<AstIdentifier, Node>> result = new ArrayList<Pair<AstIdentifier, Node>>();
        List<Node> path = new AstPath(root).rootToLeaf();
        for (int i = 0; i < path.size(); ++i) {
            Node node = path.get(i);
            if (!(node instanceof AstIdentifier) || !this.isResourceBundleIdentifier(node.getImage(), context)) continue;
            if (i + 2 < path.size()) {
                Node brackets = path.get(i + 1);
                Node string = path.get(i + 2);
                if (!(brackets instanceof AstBracketSuffix) || !(string instanceof AstString)) continue;
                result.add((Pair<AstIdentifier, Node>)Pair.of((Object)((AstIdentifier)node), (Object)string));
                continue;
            }
            if (i + 1 >= path.size() || !(path.get(i + 1) instanceof AstDotSuffix)) continue;
            result.add((Pair<AstIdentifier, Node>)Pair.of((Object)((AstIdentifier)node), (Object)path.get(i + 1)));
        }
        return result;
    }

    public String findResourceBundleIdentifier(AstPath astPath) {
        List<Node> path = astPath.leafToRoot();
        for (int i = 0; i < path.size(); ++i) {
            Node node = path.get(i);
            if (!(node instanceof AstString) || i + 2 >= path.size()) continue;
            Node brackets = path.get(i + 1);
            Node identifier = path.get(i + 2);
            if (!(brackets instanceof AstBracketSuffix) || !(identifier instanceof AstIdentifier) || !this.isResourceBundleIdentifier(identifier.getImage(), new ResolverContext())) continue;
            return identifier.getImage();
        }
        return null;
    }

    public String getValue(String bundle, String key) {
        ResourceBundleInfo rbInfo = this.getBundlesMap().get(bundle);
        if (rbInfo == null || !rbInfo.getResourceBundle().containsKey(key)) {
            return null;
        }
        try {
            return rbInfo.getResourceBundle().getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public Map<String, String> getEntries(String bundleVar) {
        ResourceBundle bundle = this.findResourceBundleForVar(bundleVar);
        ResourceBundleInfo rbInfo = this.getBundlesMap().get(bundle.getBaseName());
        if (rbInfo == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : rbInfo.getResourceBundle().keySet()) {
            String value = rbInfo.getResourceBundle().getString(key);
            result.put(key, value);
        }
        return result;
    }

    private ResourceBundle findResourceBundleForVar(String variableName) {
        List<ResourceBundle> foundBundles = this.webModule != null ? ELPlugin.Query.getResourceBundles(this.webModule.getDocumentBase(), new ResolverContext()) : Collections.emptyList();
        for (ResourceBundle b : foundBundles) {
            if (!variableName.equals(b.getVar())) continue;
            return b;
        }
        return null;
    }

    public List<ResourceBundle> getBundles(ResolverContext context) {
        FileObject docBase = this.webModule != null ? this.webModule.getDocumentBase() : null;
        return docBase != null ? ELPlugin.Query.getResourceBundles(docBase, context) : Collections.emptyList();
    }

    private synchronized Map<String, ResourceBundleInfo> getBundlesMap() {
        long bundlesHash = this.getBundlesHashCode();
        if (this.bundlesMap == null) {
            this.currentBundlesHashCode = bundlesHash;
            this.bundlesMap = this.createResourceBundleMapAndFileChangeListeners();
            LOGGER.fine("New resource bundle map created.");
        } else if (bundlesHash != this.currentBundlesHashCode) {
            this.resetResourceBundleMap();
            this.bundlesMap = this.createResourceBundleMapAndFileChangeListeners();
            this.currentBundlesHashCode = bundlesHash;
            LOGGER.fine("Resource bundle map recreated based on configuration changes.");
        }
        return this.bundlesMap;
    }

    private synchronized void resetResourceBundleMap() {
        if (this.bundlesMap == null) {
            return;
        }
        for (ResourceBundleInfo info : this.bundlesMap.values()) {
            for (FileObject fileObject : info.getFiles()) {
                fileObject.removeFileChangeListener(this.FILE_CHANGE_LISTENER);
                LOGGER.finer(String.format("Removed FileChangeListener from file %s", fileObject));
            }
        }
        this.bundlesMap = null;
        LOGGER.fine("Resource bundle map released.");
    }

    private long getBundlesHashCode() {
        long hash = 3L;
        for (ResourceBundle rb : this.getBundles(new ResolverContext())) {
            hash = 11L * hash + (long)rb.getBaseName().hashCode();
            hash = 11L * hash + (long)(rb.getVar() != null ? rb.getVar().hashCode() : 0);
        }
        return hash;
    }

    private Map<String, ResourceBundleInfo> createResourceBundleMapAndFileChangeListeners() {
        HashMap<String, ResourceBundleInfo> result = new HashMap<String, ResourceBundleInfo>();
        ClassPathProvider provider = (ClassPathProvider)this.project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = ProjectUtils.getSources((Project)this.project);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        for (ResourceBundle bundle : this.getBundles(new ResolverContext())) {
            String bundleFile = bundle.getBaseName();
            block3: for (SourceGroup sourceGroup : sourceGroups) {
                FileObject rootFolder = sourceGroup.getRootFolder();
                for (String classPathType : new String[]{"classpath/source", "classpath/compile"}) {
                    ClassPath classPath = ClassPath.getClassPath((FileObject)rootFolder, (String)classPathType);
                    if (classPath == null) continue;
                    ClassLoader classLoader = classPath.getClassLoader(false);
                    try {
                        String resourceFileName = bundleFile.replace(".", "/") + ".properties";
                        URL url = classLoader.getResource(resourceFileName);
                        if (url != null) {
                            LOGGER.finer(String.format("Found %s URL for resource bundle %s", url, resourceFileName));
                            FileObject fileObject = URLMapper.findFileObject((URL)url);
                            if (fileObject != null) {
                                if (fileObject.canWrite()) {
                                    fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)this.FILE_CHANGE_LISTENER, (Object)fileObject));
                                    LOGGER.finer(String.format("Added FileChangeListener to file %s", fileObject));
                                }
                            } else {
                                LOGGER.fine(String.format("Cannot map %s URL to FileObject!", url));
                            }
                        }
                        java.util.ResourceBundle found = java.util.ResourceBundle.getBundle(bundleFile, Locale.getDefault(), classLoader);
                        result.put(bundleFile, new ResourceBundleInfo(bundle.getFiles(), found, bundle.getVar()));
                        continue block3;
                    }
                    catch (MissingResourceException exception) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    private static final class ResourceBundleInfo {
        private final List<FileObject> files;
        private final java.util.ResourceBundle resourceBundle;
        private final String varName;

        public ResourceBundleInfo(List<FileObject> files, java.util.ResourceBundle resourceBundle, String varName) {
            this.files = files;
            this.resourceBundle = resourceBundle;
            this.varName = varName;
        }

        public List<FileObject> getFiles() {
            return this.files;
        }

        public java.util.ResourceBundle getResourceBundle() {
            return this.resourceBundle;
        }

        public String getVarName() {
            return this.varName;
        }
    }

    public static class Location {
        private final int offset;
        private final FileObject file;

        public Location(int offset, FileObject file) {
            this.offset = offset;
            this.file = file;
        }

        public int getOffset() {
            return this.offset;
        }

        public FileObject getFile() {
            return this.file;
        }
    }
}

