/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.terminal.action;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.terminal.TerminalSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class OpenInTerminalAction
extends NodeAction {
    private OpenInTerminalAction() {
        this.putValue("hideWhenDisabled", true);
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length != 1) {
            return;
        }
        for (Node node : activatedNodes) {
            Lookup lookup = node.getLookup();
            FileObject fo = (FileObject)lookup.lookup(FileObject.class);
            final String path = fo.isFolder() ? fo.getPath() : fo.getParent().getPath();
            ExecutionEnvironment env = null;
            try {
                FileSystem fileSystem = fo.getFileSystem();
                Method declaredMethod = fileSystem.getClass().getDeclaredMethod("getExecutionEnvironment", new Class[0]);
                if (declaredMethod != null) {
                    declaredMethod.setAccessible(true);
                    Object invoke = declaredMethod.invoke((Object)fileSystem, new Object[0]);
                    if (invoke instanceof ExecutionEnvironment) {
                        env = (ExecutionEnvironment)invoke;
                    }
                }
            }
            catch (FileStateInvalidException fileSystem) {
            }
            catch (IllegalAccessException fileSystem) {
            }
            catch (IllegalArgumentException fileSystem) {
            }
            catch (InvocationTargetException fileSystem) {
            }
            catch (NoSuchMethodException fileSystem) {
            }
            catch (SecurityException fileSystem) {
                // empty catch block
            }
            if (env == null) {
                env = ExecutionEnvironmentFactory.getLocal();
            }
            final ExecutionEnvironment envFinal = env;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ OpenInTerminalAction this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    TerminalSupport.openTerminal(envFinal.getDisplayName(), envFinal, path);
                }
            });
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        Lookup lookup;
        return activatedNodes.length == 1 && (lookup = activatedNodes[0].getLookup()).lookup(FileObject.class) != null;
    }

    public String getName() {
        return NbBundle.getMessage(OpenInTerminalAction.class, (String)"CTL_OpenInTerminalActionDescr");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }
}

