/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.FieldValue;
import org.netbeans.lib.profiler.heap.HprofField;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.HprofInstanceObjectValue;
import org.netbeans.lib.profiler.heap.HprofInstanceValue;
import org.netbeans.lib.profiler.heap.HprofObject;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;

class InstanceDump
extends HprofObject
implements Instance {
    final ClassDump dumpClass;

    InstanceDump(ClassDump cls, long offset) {
        super(offset);
        this.dumpClass = cls;
    }

    @Override
    public List getFieldValues() {
        long offset = this.fileOffset + (long)this.getInstanceFieldValuesOffset();
        List fields = this.dumpClass.getAllInstanceFields();
        ArrayList<HprofInstanceValue> values = new ArrayList<HprofInstanceValue>(fields.size());
        for (HprofField field : fields) {
            if (field.getValueType() == 2) {
                values.add(new HprofInstanceObjectValue(this, field, offset));
            } else {
                values.add(new HprofInstanceValue(this, field, offset));
            }
            offset += (long)field.getValueSize();
        }
        return values;
    }

    @Override
    public boolean isGCRoot() {
        return this.getHprof().getGCRoot(this) != null;
    }

    @Override
    public long getInstanceId() {
        return this.dumpClass.getHprofBuffer().getID(this.fileOffset + 1L);
    }

    @Override
    public int getInstanceNumber() {
        return this.getHprof().idToOffsetMap.get(this.getInstanceId()).getIndex();
    }

    @Override
    public JavaClass getJavaClass() {
        return this.dumpClass;
    }

    @Override
    public Instance getNearestGCRootPointer() {
        return this.getHprof().getNearestGCRootPointer(this);
    }

    @Override
    public long getReachableSize() {
        return 0L;
    }

    @Override
    public List getReferences() {
        return this.getHprof().findReferencesFor(this.getInstanceId());
    }

    @Override
    public long getRetainedSize() {
        return this.getHprof().getRetainedSize(this);
    }

    @Override
    public long getSize() {
        return this.dumpClass.getInstanceSize();
    }

    @Override
    public List getStaticFieldValues() {
        return this.dumpClass.getStaticFieldValues();
    }

    @Override
    public Object getValueOfField(String name) {
        Iterator fIt = this.getFieldValues().iterator();
        FieldValue matchingFieldValue = null;
        while (fIt.hasNext()) {
            FieldValue fieldValue = (FieldValue)fIt.next();
            if (!fieldValue.getField().getName().equals(name)) continue;
            matchingFieldValue = fieldValue;
        }
        if (matchingFieldValue == null) {
            return null;
        }
        if (matchingFieldValue instanceof HprofInstanceObjectValue) {
            return ((HprofInstanceObjectValue)matchingFieldValue).getInstance();
        }
        return ((HprofInstanceValue)matchingFieldValue).getTypeValue();
    }

    private int getInstanceFieldValuesOffset() {
        int idSize = this.dumpClass.getHprofBuffer().getIDSize();
        return 1 + idSize + 4 + idSize + 4;
    }

    private HprofHeap getHprof() {
        return this.dumpClass.getHprof();
    }
}

