/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.parser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.html.editor.lib.api.ProblemDescription;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementFilter;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.FeaturedNode;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.openide.util.CharSequences;

public class ElementsFactory {
    private CharSequence source;

    ElementsFactory(CharSequence source) {
        this.source = source;
    }

    Text createText(int startOffset, int endOffset) {
        return new Text(startOffset, endOffset, this.source);
    }

    ModifiableCloseTag createCloseTag(int startOffset, int endOffset, byte nameLen) {
        return new CommonCloseTag(this.source, startOffset, endOffset, nameLen);
    }

    ModifiableOpenTag createOpenTag(int startOffset, int endOffset, byte nameLen) {
        return new CommonOpenTag(this.source, startOffset, endOffset, nameLen);
    }

    ModifiableOpenTag createVirtualOpenTag(CharSequence name) {
        return new VirtualOpenTag(name);
    }

    ModifiableOpenTag createEmptyOpenTag(int startOffset, int endOffset, byte nameLen) {
        return new EmptyOpenTag(this.source, startOffset, endOffset, nameLen);
    }

    Root createRoot() {
        return new Root(this.source, null);
    }

    CommonAttribute createAttribute(int nameOffset, int valueOffset, short nameLen, int valueLen) {
        return new CommonAttribute(this.source, nameOffset, valueOffset, nameLen, valueLen);
    }

    CommonAttribute createAttribute(int nameOffset, short nameLen) {
        return new CommonAttribute(this.source, nameOffset, nameLen);
    }

    static class Text
    implements ModifiableElement {
        private int from;
        private int to;
        private CharSequence source;
        private Node parent;

        public Text(int from, int to, CharSequence source) {
            this.from = from;
            this.to = to;
            this.source = source;
        }

        public int from() {
            return this.from;
        }

        public int to() {
            return this.to;
        }

        public ElementType type() {
            return ElementType.TEXT;
        }

        public CharSequence image() {
            return this.source.subSequence(this.from, this.to);
        }

        public CharSequence id() {
            return null;
        }

        public Collection<ProblemDescription> problems() {
            return Collections.emptyList();
        }

        public Node parent() {
            return this.parent;
        }

        @Override
        public void detachFromParent() {
        }

        @Override
        public void setEndOffset(int endOffset) {
            this.to = endOffset;
        }

        @Override
        public void setParent(Node parent) {
            this.parent = parent;
        }

        public String toString() {
            return this.type().name() + ';' + ' ' + this.from() + "-" + this.to() + ' ' + '\"' + this.escapeEOLs(this.image()) + '\"';
        }

        private String escapeEOLs(CharSequence text) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\n') {
                    sb.append("\\n");
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
    }

    static class CommonCloseTag
    extends TagElement
    implements ModifiableCloseTag {
        private OpenTag matchingOpenTag;

        public CommonCloseTag(CharSequence source, int startOffset, int endOffset, byte nameLen) {
            super(source, startOffset, endOffset, nameLen);
        }

        public ElementType type() {
            return ElementType.CLOSE_TAG;
        }

        public OpenTag matchingOpenTag() {
            return this.matchingOpenTag;
        }

        @Override
        public void setMatchingOpenTag(OpenTag openTag) {
            this.matchingOpenTag = openTag;
        }

        @Override
        protected int nameOffsetToStartOffsetDiff() {
            return 2;
        }
    }

    static class CommonOpenTag
    extends EmptyOpenTag {
        private List<Element> children;
        private CloseTag matchingEndTag;
        private int logicalEndOffset;

        public CommonOpenTag(CharSequence source, int startOffset, int endOffset, byte nameLen) {
            super(source, startOffset, endOffset, nameLen);
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public void setMatchingCloseTag(CloseTag endTag) {
            this.matchingEndTag = endTag;
        }

        @Override
        public CloseTag matchingCloseTag() {
            return this.matchingEndTag;
        }

        @Override
        public void addChild(Element child) {
            if (this.children == null) {
                this.children = new ArrayList<Element>(1);
            }
            this.children.add(child);
            ((ModifiableElement)child).setParent((Node)this);
        }

        @Override
        public void addChildren(Collection<Element> elements) {
            for (Element e : new LinkedList<Element>(elements)) {
                this.addChild(e);
            }
        }

        @Override
        public void removeChild(Element element) {
            if (this.children == null) {
                return;
            }
            this.children.remove(element);
            if (this.children.isEmpty()) {
                this.children = null;
            }
            ((ModifiableElement)element).setParent(null);
        }

        @Override
        public void removeChildren(Collection<Element> toRemove) {
            if (this.children == null) {
                return;
            }
            Iterator<Element> childrenIterator = toRemove.iterator();
            while (childrenIterator.hasNext()) {
                Element child = childrenIterator.next();
                ((ModifiableElement)child).setParent(null);
                childrenIterator.remove();
            }
            if (this.children().isEmpty()) {
                this.children = null;
            }
        }

        @Override
        public void insertChildBefore(Element toInsert, Element element) {
            int index = this.children.indexOf(element);
            if (index == -1) {
                return;
            }
            this.children.add(index, toInsert);
            ((ModifiableElement)toInsert).setParent((Node)this);
        }

        @Override
        public Collection<Element> children() {
            return this.children == null ? Collections.emptyList() : this.children;
        }

        @Override
        public Collection<Element> children(ElementType type) {
            ArrayList<Element> filtered = new ArrayList<Element>();
            for (Element e : this.children()) {
                if (e.type() != type) continue;
                filtered.add(e);
            }
            return filtered;
        }

        @Override
        public Collection<Element> children(ElementFilter filter) {
            ArrayList<Element> filtered = new ArrayList<Element>();
            for (Element e : this.children()) {
                if (!filter.accepts(e)) continue;
                filtered.add(e);
            }
            return filtered;
        }

        @Override
        public <T extends Element> Collection<T> children(Class<T> type) {
            ArrayList<Element> filtered = new ArrayList<Element>();
            for (Element child : this.children()) {
                if (!type.isAssignableFrom(child.getClass())) continue;
                filtered.add((Element)type.cast(child));
            }
            return filtered;
        }

        @Override
        public void setSemanticEndOffset(int endOffset) {
            this.logicalEndOffset = endOffset;
        }

        @Override
        public int semanticEnd() {
            return this.logicalEndOffset;
        }
    }

    static class VirtualOpenTag
    implements OpenTag,
    ModifiableOpenTag {
        private Collection<Attribute> attrs;
        private CharSequence name;
        private List<Element> children;
        private CloseTag matchingCloseTag;
        private int logicalEndOffset;
        private Node parent;

        public VirtualOpenTag(CharSequence name) {
            this.name = name;
        }

        void addAttribute(Attribute attr) {
            if (this.attrs == null) {
                this.attrs = new ArrayList<Attribute>(1);
            }
            this.attrs.add(attr);
        }

        void addAttributes(Collection<Attribute> attributes) {
            if (this.attrs == null) {
                this.attrs = new ArrayList<Attribute>(1);
            }
            this.attrs.addAll(attributes);
        }

        public Collection<Attribute> attributes() {
            return this.attrs == null ? Collections.emptyList() : this.attrs;
        }

        public Collection<Attribute> attributes(AttributeFilter filter) {
            ArrayList<Attribute> filtered = new ArrayList<Attribute>(1);
            for (Attribute a : this.attributes()) {
                if (!filter.accepts(a)) continue;
                filtered.add(a);
            }
            return filtered;
        }

        public Attribute getAttribute(String name) {
            for (Attribute a : this.attributes()) {
                if (!LexerUtils.equals((CharSequence)name, (CharSequence)a.name(), (boolean)true, (boolean)false)) continue;
                return a;
            }
            return null;
        }

        public boolean isEmpty() {
            return false;
        }

        public CloseTag matchingCloseTag() {
            return this.matchingCloseTag;
        }

        public int semanticEnd() {
            return this.logicalEndOffset;
        }

        public CharSequence name() {
            return this.name;
        }

        public CharSequence namespacePrefix() {
            int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
            return colonIndex == -1 ? null : this.name().subSequence(0, colonIndex);
        }

        public CharSequence unqualifiedName() {
            int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
            return colonIndex == -1 ? this.name() : this.name().subSequence(colonIndex + 1, this.name().length());
        }

        public int from() {
            return -1;
        }

        public int to() {
            return -1;
        }

        public ElementType type() {
            return ElementType.OPEN_TAG;
        }

        public CharSequence image() {
            return null;
        }

        public CharSequence id() {
            return this.name();
        }

        public Collection<ProblemDescription> problems() {
            return Collections.emptyList();
        }

        public Node parent() {
            return this.parent;
        }

        public Collection<Element> children() {
            return this.children == null ? Collections.emptyList() : this.children;
        }

        public Collection<Element> children(ElementType type) {
            ArrayList<Element> filtered = new ArrayList<Element>();
            for (Element e : this.children()) {
                if (e.type() != type) continue;
                filtered.add(e);
            }
            return filtered;
        }

        public Collection<Element> children(ElementFilter filter) {
            ArrayList<Element> filtered = new ArrayList<Element>();
            for (Element e : this.children()) {
                if (!filter.accepts(e)) continue;
                filtered.add(e);
            }
            return filtered;
        }

        public <T extends Element> Collection<T> children(Class<T> type) {
            ArrayList<Element> filtered = new ArrayList<Element>();
            for (Element child : this.children()) {
                if (!type.isAssignableFrom(child.getClass())) continue;
                filtered.add((Element)type.cast(child));
            }
            return filtered;
        }

        @Override
        public void insertChildBefore(Element toInsert, Element element) {
            int index;
            if (this.children == null) {
                this.children = new ArrayList<Element>();
            }
            if ((index = this.children.indexOf(element)) == -1) {
                return;
            }
            this.children.add(index, toInsert);
            ((ModifiableElement)toInsert).setParent((Node)this);
        }

        @Override
        public void setParent(Node parent) {
            this.parent = parent;
        }

        @Override
        public void addChild(Element child) {
            if (this.children == null) {
                this.children = new ArrayList<Element>(1);
            }
            this.children.add(child);
            ((ModifiableElement)child).setParent((Node)this);
        }

        @Override
        public void addChildren(Collection<Element> elements) {
            for (Element e : new LinkedList<Element>(elements)) {
                this.addChild(e);
            }
        }

        @Override
        public void removeChild(Element element) {
            if (this.children == null) {
                return;
            }
            this.children.remove(element);
            if (this.children.isEmpty()) {
                this.children = null;
            }
            ((ModifiableElement)element).setParent(null);
        }

        @Override
        public void removeChildren(Collection<Element> toRemove) {
            if (this.children == null) {
                return;
            }
            Iterator<Element> childrenIterator = toRemove.iterator();
            while (childrenIterator.hasNext()) {
                Element child = childrenIterator.next();
                ((ModifiableElement)child).setParent(null);
                childrenIterator.remove();
            }
            if (this.children().isEmpty()) {
                this.children = null;
            }
        }

        @Override
        public void setEndOffset(int endOffset) {
        }

        @Override
        public void detachFromParent() {
            ModifiableOpenTag mot = (ModifiableOpenTag)this.parent();
            if (mot != null) {
                mot.removeChild(this);
                this.setParent(null);
            }
        }

        @Override
        public void setSemanticEndOffset(int endOffset) {
            this.logicalEndOffset = endOffset;
        }

        @Override
        public void setAttribute(Attribute attribute) {
            this.addAttribute(attribute);
        }

        @Override
        public void setMatchingCloseTag(CloseTag closeTag) {
            this.matchingCloseTag = closeTag;
        }

        public String toString() {
            return this.name() + "(" + this.type().name() + ")" + "; (virtual)";
        }
    }

    static class EmptyOpenTag
    extends TagElement
    implements OpenTag,
    ModifiableOpenTag {
        private Collection<Attribute> attrs;

        public EmptyOpenTag(CharSequence source, int startOffset, int endOffset, byte nameLen) {
            super(source, startOffset, endOffset, nameLen);
        }

        void addAttribute(Attribute attr) {
            if (this.attrs == null) {
                this.attrs = new ArrayList<Attribute>();
            }
            this.attrs.add(attr);
        }

        void addAttributes(Collection<Attribute> attributes) {
            if (this.attrs == null) {
                this.attrs = new ArrayList<Attribute>();
            }
            this.attrs.addAll(attributes);
        }

        public Collection<Attribute> attributes() {
            return this.attrs == null ? Collections.emptyList() : this.attrs;
        }

        public Collection<Attribute> attributes(AttributeFilter filter) {
            ArrayList<Attribute> filtered = new ArrayList<Attribute>(1);
            for (Attribute a : this.attributes()) {
                if (!filter.accepts(a)) continue;
                filtered.add(a);
            }
            return filtered;
        }

        public Attribute getAttribute(String name) {
            for (Attribute a : this.attributes()) {
                if (!LexerUtils.equals((CharSequence)name, (CharSequence)a.name(), (boolean)true, (boolean)false)) continue;
                return a;
            }
            return null;
        }

        public boolean isEmpty() {
            return true;
        }

        public CloseTag matchingCloseTag() {
            return null;
        }

        public int semanticEnd() {
            return this.to();
        }

        public Collection<Element> children() {
            return Collections.emptyList();
        }

        public Collection<Element> children(ElementType type) {
            return Collections.emptyList();
        }

        public Collection<Element> children(ElementFilter filter) {
            return Collections.emptyList();
        }

        public <T extends Element> Collection<T> children(Class<T> type) {
            return Collections.emptyList();
        }

        public ElementType type() {
            return ElementType.OPEN_TAG;
        }

        @Override
        protected int nameOffsetToStartOffsetDiff() {
            return 1;
        }

        @Override
        public void addChild(Element element) {
        }

        @Override
        public void removeChild(Element element) {
        }

        @Override
        public void setSemanticEndOffset(int endOffset) {
        }

        @Override
        public void setAttribute(Attribute attribute) {
            this.addAttribute(attribute);
        }

        @Override
        public void removeChildren(Collection<Element> children) {
        }

        @Override
        public void addChildren(Collection<Element> element) {
        }

        @Override
        public void insertChildBefore(Element toInsert, Element element) {
        }

        @Override
        public void setMatchingCloseTag(CloseTag closeTag) {
        }

        @Override
        public String toString() {
            return super.toString() + (this.isEmpty() ? "(self close tag)" : "");
        }
    }

    static class Root
    extends CommonOpenTag
    implements FeaturedNode {
        private static final String ROOT = "root";
        private String namespace;

        public Root(CharSequence source, String namespace) {
            super(source, 0, source.length(), (byte)0);
            this.namespace = namespace;
        }

        @Override
        public CharSequence name() {
            return ROOT;
        }

        @Override
        public int to() {
            return this.source.length();
        }

        @Override
        public ElementType type() {
            return ElementType.ROOT;
        }

        public Object getProperty(String propertyName) {
            if (propertyName.equalsIgnoreCase("namespace")) {
                return this.namespace;
            }
            return null;
        }
    }

    static class CommonAttribute
    implements Attribute {
        private CharSequence source;
        private int nameOffset;
        private short valueOffset2nameOffsetDiff;
        private short nameLen;
        private int valueLen;

        public CommonAttribute(CharSequence source, int nameOffset, short nameLen) {
            this.source = source;
            this.nameOffset = nameOffset;
            this.valueOffset2nameOffsetDiff = (short)-1;
            this.nameLen = nameLen;
            this.valueLen = -1;
        }

        public CommonAttribute(CharSequence source, int nameOffset, int valueOffset, short nameLen, int valueLen) {
            this.source = source;
            this.nameOffset = nameOffset;
            this.valueOffset2nameOffsetDiff = (short)(valueOffset - nameOffset);
            this.nameLen = nameLen;
            this.valueLen = valueLen;
        }

        public int nameOffset() {
            return this.nameOffset;
        }

        public CharSequence name() {
            return this.source.subSequence(this.nameOffset, this.nameOffset + this.nameLen);
        }

        public int valueOffset() {
            return this.valueOffset2nameOffsetDiff == -1 ? -1 : this.nameOffset + this.valueOffset2nameOffsetDiff;
        }

        public CharSequence value() {
            if (this.valueLen == -1) {
                return null;
            }
            int diff = this.source.length() - this.valueOffset();
            if (diff < 0) {
                assert (false) : String.format("valueOffset:%s > source.length:%s", this.valueOffset(), this.source.length());
                return null;
            }
            if (diff < this.valueLen) {
                assert (false) : String.format("valueOffset:%s + valueLen:%s > source.length:%s", this.valueOffset(), this.valueLen, this.source.length());
                return null;
            }
            return this.source.subSequence(this.valueOffset(), this.valueOffset() + this.valueLen);
        }

        public boolean isValueQuoted() {
            if (this.value() == null) {
                return false;
            }
            if (this.valueLen < 2) {
                return false;
            }
            CharSequence value = this.value();
            return !(value.charAt(0) != '\'' && value.charAt(0) != '\"' || value.charAt(value.length() - 1) != '\'' && value.charAt(value.length() - 1) != '\"');
        }

        public CharSequence unquotedValue() {
            if (this.value() == null) {
                return null;
            }
            return this.isValueQuoted() ? this.value().subSequence(1, this.value().length() - 1) : this.value();
        }

        public CharSequence namespacePrefix() {
            int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
            return colonIndex == -1 ? null : this.name().subSequence(0, colonIndex);
        }

        public CharSequence unqualifiedName() {
            int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
            return colonIndex == -1 ? this.name() : this.name().subSequence(colonIndex + 1, this.name().length());
        }

        public int from() {
            return this.nameOffset();
        }

        public int to() {
            return this.value() != null ? this.valueOffset() + this.valueLen : this.nameOffset() + this.nameLen;
        }

        public ElementType type() {
            return ElementType.ATTRIBUTE;
        }

        public CharSequence image() {
            return this.source.subSequence(this.from(), this.to());
        }

        public CharSequence id() {
            return this.type().name();
        }

        public Collection<ProblemDescription> problems() {
            return Collections.emptyList();
        }

        public Node parent() {
            return null;
        }
    }

    static abstract class TagElement
    implements Named,
    ModifiableElement {
        protected CharSequence source;
        private int startOffset;
        private short endOffsetToStartOffsetDiff;
        private byte nameLen;
        private Node parent;

        public TagElement(CharSequence source, int startOffset, int endOffset, byte nameLen) {
            assert (nameLen >= 0);
            this.source = source;
            this.startOffset = startOffset;
            this.setEndOffset(endOffset);
            this.setNameLen(nameLen);
        }

        @Override
        public void setEndOffset(int endOffset) {
            this.endOffsetToStartOffsetDiff = (short)(endOffset - this.startOffset);
        }

        protected void setNameLen(byte nameLen) {
            assert (nameLen >= 0);
            this.nameLen = nameLen;
        }

        protected abstract int nameOffsetToStartOffsetDiff();

        private int nameOffset() {
            return this.startOffset + this.nameOffsetToStartOffsetDiff();
        }

        public CharSequence name() {
            return this.source.subSequence(this.nameOffset(), this.nameOffset() + this.nameLen);
        }

        public CharSequence namespacePrefix() {
            int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
            return colonIndex == -1 ? null : this.name().subSequence(0, colonIndex);
        }

        public CharSequence unqualifiedName() {
            int colonIndex = CharSequences.indexOf((CharSequence)this.name(), (CharSequence)":");
            return colonIndex == -1 ? this.name() : this.name().subSequence(colonIndex + 1, this.name().length());
        }

        public int from() {
            return this.startOffset;
        }

        public int to() {
            return this.startOffset + this.endOffsetToStartOffsetDiff;
        }

        public CharSequence image() {
            return this.source.subSequence(this.from(), this.to());
        }

        public CharSequence id() {
            return this.name();
        }

        public Collection<ProblemDescription> problems() {
            return Collections.emptyList();
        }

        @Override
        public void setParent(Node parent) {
            this.parent = parent;
        }

        public Node parent() {
            return this.parent;
        }

        public String toString() {
            return this.name() + "(" + this.type().name() + ")" + "; " + this.from() + "-" + this.to();
        }

        @Override
        public void detachFromParent() {
            this.setParent(null);
        }
    }

    static interface ModifiableOpenTag
    extends ModifiableElement,
    OpenTag {
        public void addChild(Element var1);

        public void insertChildBefore(Element var1, Element var2);

        public void addChildren(Collection<Element> var1);

        public void removeChildren(Collection<Element> var1);

        public void removeChild(Element var1);

        public void setSemanticEndOffset(int var1);

        public void setMatchingCloseTag(CloseTag var1);

        public void setAttribute(Attribute var1);
    }

    static interface ModifiableCloseTag
    extends ModifiableElement,
    CloseTag {
        public void setMatchingOpenTag(OpenTag var1);
    }

    static interface ModifiableElement
    extends Element {
        public void detachFromParent();

        public void setEndOffset(int var1);

        public void setParent(Node var1);
    }
}

