/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.UIManager;
import org.netbeans.lib.profiler.ui.components.ImagePanel;

public class ImageBlenderPanel
extends ImagePanel {
    private Color background;
    private Image image1;
    private Image image2;
    private float blendAlpha;

    public ImageBlenderPanel(Image image1, Image image2) {
        this(image1, image2, UIManager.getColor("Panel.background"), 0.0f);
    }

    public ImageBlenderPanel(Image image1, Image image2, Color background, float blendAlpha) {
        super(ImageBlenderPanel.createBlendedImage(image1, image2, background, blendAlpha));
        this.background = background;
        this.blendAlpha = blendAlpha;
        this.image1 = image1;
        this.image2 = image2;
    }

    public void setBlendAlpha(float blendAlpha) {
        this.setImage(ImageBlenderPanel.createBlendedImage(this.image1, this.image2, this.background, blendAlpha));
        this.blendAlpha = blendAlpha;
    }

    private static Image createBlendedImage(Image image1, Image image2, Color background, float blendAlpha) {
        Image i1 = ImageBlenderPanel.loadImage(image1);
        Image i2 = ImageBlenderPanel.loadImage(image2);
        int blendedImageWidth = Math.max(i1.getWidth(null), i2.getWidth(null));
        int blendedImageHeight = Math.max(i1.getHeight(null), i2.getHeight(null));
        BufferedImage blendedImage = new BufferedImage(blendedImageWidth, blendedImageHeight, 1);
        Graphics2D blendedImageGraphics = (Graphics2D)blendedImage.getGraphics();
        blendedImageGraphics.setColor(background);
        blendedImageGraphics.fillRect(0, 0, blendedImageWidth, blendedImageHeight);
        blendedImageGraphics.drawImage(i1, 0, 0, null);
        blendedImageGraphics.setComposite(AlphaComposite.getInstance(3, blendAlpha));
        blendedImageGraphics.drawImage(i2, 0, 0, null);
        return blendedImage;
    }
}

