/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.cast;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.cast.JSStringToNumberNode;
import com.oracle.truffle.js.nodes.cast.JSToIntegerAsIntNodeGen;
import com.oracle.truffle.js.nodes.cast.JSToNumberNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.SafeInteger;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.objects.JSObject;

public abstract class JSToIntegerAsIntNode
extends JavaScriptBaseNode {
    @NeverDefault
    public static JSToIntegerAsIntNode create() {
        return JSToIntegerAsIntNodeGen.create();
    }

    public abstract int executeInt(Object var1);

    @Specialization
    protected static int doInteger(int value) {
        return value;
    }

    @Specialization
    protected static int doBoolean(boolean value) {
        return JSRuntime.booleanToNumber(value);
    }

    @Specialization(guards={"isLongRepresentableAsInt32(value.longValue())"})
    protected static int doSafeIntegerInt32Range(SafeInteger value) {
        return value.intValue();
    }

    @Specialization(guards={"!isLongRepresentableAsInt32(value.longValue())"})
    protected static int doSafeIntegerOther(SafeInteger value) {
        if (value.isNegative()) {
            return Integer.MIN_VALUE;
        }
        return Integer.MAX_VALUE;
    }

    @Specialization
    protected static int doDouble(double value) {
        return (int)value;
    }

    @Specialization(guards={"isUndefined(value)"})
    protected static int doUndefined(Object value) {
        return 0;
    }

    @Specialization(guards={"isJSNull(value)"})
    protected static int doNull(Object value) {
        return 0;
    }

    @Specialization
    protected final int doSymbol(Symbol value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a Symbol value", this);
    }

    @Specialization
    protected final int doBigInt(BigInt value) {
        throw Errors.createTypeErrorCannotConvertToNumber("a BigInt value", this);
    }

    @Specialization
    protected int doString(TruffleString value, @Cached JSToIntegerAsIntNode nestedToIntegerNode, @Cached JSStringToNumberNode stringToNumberNode) {
        return nestedToIntegerNode.executeInt(stringToNumberNode.execute(value));
    }

    @Specialization
    protected int doJSObject(JSObject value, @Cached.Shared @Cached JSToNumberNode toNumberNode) {
        return JSRuntime.toInt32(toNumberNode.executeNumber((Object)value));
    }

    @Specialization(guards={"isJSObject(value) || isForeignObject(value)"}, replaces={"doJSObject"})
    protected int doJSOrForeignObject(Object value, @Cached.Shared @Cached JSToNumberNode toNumberNode) {
        return JSRuntime.toInt32(toNumberNode.executeNumber(value));
    }
}

