/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.change;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.change.AbstractCompositeOntologyChange;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class SplitSubClassAxioms
extends AbstractCompositeOntologyChange {
    private static final long serialVersionUID = 40000L;

    public SplitSubClassAxioms(@Nonnull Set<OWLOntology> ontologies, @Nonnull OWLDataFactory dataFactory) {
        super(dataFactory);
        for (OWLOntology ont : ontologies) {
            assert (ont != null);
            for (OWLSubClassOfAxiom ax : ont.getAxioms(AxiomType.SUBCLASS_OF)) {
                ConjunctSplitter splitter = new ConjunctSplitter();
                ax.getSuperClass().accept(splitter);
                if (splitter.result.size() <= 1) continue;
                this.addChange(new RemoveAxiom(ont, ax));
                for (OWLClassExpression desc : splitter.result) {
                    assert (desc != null);
                    OWLSubClassOfAxiom replAx = this.getDataFactory().getOWLSubClassOfAxiom(ax.getSubClass(), desc);
                    this.addChange(new AddAxiom(ont, replAx));
                }
            }
        }
    }

    private static class ConjunctSplitter
    implements OWLClassExpressionVisitor {
        final Set<OWLClassExpression> result = new HashSet<OWLClassExpression>();

        ConjunctSplitter() {
        }

        @Override
        public void visit(OWLClass ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLDataAllValuesFrom ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLDataExactCardinality ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLDataMaxCardinality ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLDataMinCardinality ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLDataSomeValuesFrom ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLDataHasValue ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectAllValuesFrom ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectComplementOf ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectExactCardinality ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectIntersectionOf ce) {
            for (OWLClassExpression op : ce.getOperands()) {
                op.accept(this);
            }
        }

        @Override
        public void visit(OWLObjectMaxCardinality ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectMinCardinality ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectOneOf ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectHasSelf ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectSomeValuesFrom ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectUnionOf ce) {
            this.result.add(ce);
        }

        @Override
        public void visit(OWLObjectHasValue ce) {
            this.result.add(ce);
        }
    }
}

