/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.JOptionPane;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.protege.editor.core.FileUtils;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.ui.progress.BackgroundTask;
import org.protege.editor.core.ui.util.ErrorMessage;
import org.protege.editor.core.update.PluginInfo;
import org.protege.editor.core.util.ProtegeDirectories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginInstaller {
    private static final Logger logger = LoggerFactory.getLogger(PluginInstaller.class);
    private final List<PluginInfo> updates;

    public PluginInstaller(List<PluginInfo> updates) {
        this.updates = new ArrayList<PluginInfo>(updates);
    }

    public void run() {
        BackgroundTask installAllTask = ProtegeApplication.getBackgroundTaskManager().startTask("installing plugins");
        Runnable r = () -> {
            boolean errorsFound = false;
            boolean someInstalled = false;
            try {
                for (PluginInfo info : this.updates) {
                    InstallerResult result = this.install(info);
                    switch (result.ordinal()) {
                        case 1: {
                            errorsFound = true;
                            break;
                        }
                        case 2: {
                            someInstalled = true;
                        }
                    }
                }
            }
            finally {
                ProtegeApplication.getBackgroundTaskManager().endTask(installAllTask);
            }
            if (errorsFound) {
                ErrorMessage.showErrorMessage("Plugin Installer", "Some errors occurred whilst installing the downloaded plugins.");
            } else if (someInstalled) {
                JOptionPane.showMessageDialog(null, "Updates will take effect when you next start Protege.");
            } else {
                JOptionPane.showMessageDialog(null, "Updates will take effect when you next start Protege.");
            }
        };
        Thread t = new Thread(r, "Installing plugins thread");
        t.setPriority(1);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstallerResult install(PluginInfo info) {
        logger.info(LogBanner.start("Downloading and Installing Plugin"));
        BackgroundTask downloading = ProtegeApplication.getBackgroundTaskManager().startTask("downloading " + info.getLabel());
        logger.info("Downloading the {} plugin (Version {})", (Object)info.getLabel(), (Object)info.getAvailableVersion());
        try {
            Optional<File> downloadedPlugin = this.downloadPlugin(info);
            if (!downloadedPlugin.isPresent()) {
                logger.error("An error occurred whilst downloading the {} plugin.  The plugin has not been installed.", (Object)info.getLabel());
                InstallerResult installerResult = InstallerResult.ERROR;
                return installerResult;
            }
            Optional<File> installedPluginFile = PluginInstaller.copyPluginToInstallLocation(downloadedPlugin.get(), info);
            if (!installedPluginFile.isPresent()) {
                logger.error("There was an error whilst trying to install the {} plugin. It has not been installed", (Object)info.getLabel());
                InstallerResult installerResult = InstallerResult.ERROR;
                return installerResult;
            }
            if (this.installPlugin(installedPluginFile.get(), info)) {
                InstallerResult installerResult = InstallerResult.INSTALLED;
                return installerResult;
            }
            InstallerResult installerResult = InstallerResult.DOWNLOADED;
            return installerResult;
        }
        catch (IOException | URISyntaxException t) {
            logger.error("An error occurred whilst downloading and installing the {} plugin: {}", new Object[]{info.getLabel(), t.getMessage(), t});
            InstallerResult installerResult = InstallerResult.ERROR;
            return installerResult;
        }
        finally {
            logger.info(LogBanner.end());
            ProtegeApplication.getBackgroundTaskManager().endTask(downloading);
        }
    }

    private Optional<File> downloadPlugin(PluginInfo info) throws IOException {
        byte[] buffer;
        int read;
        URL downloadURL = info.getDownloadURL();
        logger.info("Downloading the {} plugin from: {}", (Object)info.getLabel(), (Object)downloadURL);
        File tempPluginFile = Files.createTempFile(info.getId(), ".jar", new FileAttribute[0]).toFile();
        tempPluginFile.deleteOnExit();
        URLConnection conn = downloadURL.openConnection();
        BufferedInputStream bis = new BufferedInputStream(conn.getInputStream());
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(tempPluginFile));
        while ((read = bis.read(buffer = new byte[4068])) != -1) {
            bos.write(buffer, 0, read);
        }
        bis.close();
        bos.flush();
        bos.close();
        logger.info("The {} plugin has been downloaded to {}", (Object)info.getLabel(), (Object)tempPluginFile.getAbsolutePath());
        if (downloadURL.getFile().endsWith(".zip")) {
            return PluginInstaller.extractPlugin(tempPluginFile, info);
        }
        return Optional.of(tempPluginFile);
    }

    private static Optional<File> getPluginFileName(PluginInfo info) {
        Bundle pluginDescriptor = info.getPluginDescriptor();
        if (pluginDescriptor == null) {
            return Optional.empty();
        }
        String locationURL = pluginDescriptor.getLocation();
        File existingPluginLocation = new File(locationURL.substring(locationURL.indexOf(":") + 1, locationURL.length()));
        return Optional.of(existingPluginLocation);
    }

    private static File getPluginBackupFileName(File pluginFileName) {
        return new File(pluginFileName.getAbsolutePath() + ".old");
    }

    private static Optional<File> moveExistingPluginToBackupLocation(PluginInfo pluginInfo) {
        Optional<File> existingPluginFileName = PluginInstaller.getPluginFileName(pluginInfo);
        if (!existingPluginFileName.isPresent()) {
            return Optional.empty();
        }
        File backupFileName = PluginInstaller.getPluginBackupFileName(existingPluginFileName.get());
        if (existingPluginFileName.get().renameTo(backupFileName)) {
            return Optional.of(backupFileName);
        }
        return Optional.empty();
    }

    private static Optional<File> copyPluginToInstallLocation(File downloadedPlugin, PluginInfo info) throws URISyntaxException {
        Optional<File> backupFileName = PluginInstaller.moveExistingPluginToBackupLocation(info);
        File pluginsFolder = new File(System.getProperty("org.protege.plugin.dir"));
        String destinationFileName = String.format("%s-%s.jar", info.getId(), info.getAvailableVersion());
        File downloadedPluginDestination = new File(pluginsFolder, destinationFileName);
        try {
            FileUtils.copyFile(downloadedPlugin, downloadedPluginDestination);
            logger.info("Copied the {} plugin to {} in the plugins directory", (Object)info.getLabel(), (Object)downloadedPluginDestination.getName());
            PluginInstaller.deletePluginBackup(backupFileName);
            return Optional.of(downloadedPluginDestination);
        }
        catch (IOException e) {
            try {
                File userPluginDirectory = ProtegeDirectories.getUserPluginDirectory();
                logger.info("Could not copy the plugin to Protege plugins directory: {}", (Object)e.getMessage());
                File userDirectoryPluginFile = new File(userPluginDirectory, info.getId() + ".jar");
                FileUtils.copyFileToDirectory(downloadedPlugin, userDirectoryPluginFile);
                logger.info("Copied the {} plugin to the user plugin directory at {}.  This plugin will only be use-able by the current user.", (Object)info.getLabel(), (Object)userPluginDirectory);
                PluginInstaller.deletePluginBackup(backupFileName);
                return Optional.of(userDirectoryPluginFile);
            }
            catch (IOException ioe) {
                logger.error("An error occurred whilst attempting to save the plugin: {}", (Object)ioe.getMessage(), (Object)ioe);
                return Optional.empty();
            }
        }
    }

    private static void deletePluginBackup(Optional<File> existingPluginLocation) {
        if (existingPluginLocation.isPresent() && existingPluginLocation.get().exists()) {
            FileUtils.deleteRecursively(existingPluginLocation.get());
        }
    }

    private static Optional<File> extractPlugin(File pluginArchive, PluginInfo info) throws IOException {
        ZipEntry entry;
        logger.info("Extracting {} plugin from zip file ", (Object)info.getLabel());
        File tempDir = new File(pluginArchive.getParentFile(), pluginArchive.getName() + "-extracted");
        tempDir.deleteOnExit();
        tempDir.mkdir();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(pluginArchive)));
        byte[] buffer = new byte[4068];
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.getName().contains(".DS_Store") || entry.getName().contains("__MACOSX")) continue;
            File curFile = new File(tempDir, entry.getName());
            if (!curFile.toPath().normalize().startsWith(tempDir.toPath().normalize())) {
                throw new IOException("Bad zip entry");
            }
            if (entry.isDirectory()) {
                curFile.mkdirs();
                continue;
            }
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(curFile));
            int count = 0;
            while ((count = zis.read(buffer)) != -1) {
                ((OutputStream)os).write(buffer, 0, count);
            }
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
        }
        return PluginInstaller.getPluginDir(tempDir);
    }

    private static Optional<File> getPluginDir(File startDir) {
        if (!startDir.isDirectory()) {
            if (startDir.getName().endsWith(".jar")) {
                return Optional.of(startDir);
            }
            return Optional.empty();
        }
        File[] files = startDir.listFiles();
        if (files == null) {
            return Optional.empty();
        }
        for (File f : files) {
            Optional<File> pluginDir = PluginInstaller.getPluginDir(f);
            if (!pluginDir.isPresent()) continue;
            return pluginDir;
        }
        return Optional.empty();
    }

    private boolean installPlugin(File pluginLocation, PluginInfo info) {
        if (info.getPluginDescriptor() == null) {
            logger.info("Installing the {} plugin", (Object)info.getLabel());
            BundleContext context = ProtegeApplication.getContext();
            try {
                Bundle b = context.installBundle("file:" + pluginLocation.getPath());
                b.start();
                return true;
            }
            catch (BundleException e) {
                logger.info("The {} plugin requires a restart of Prot\u00e9g\u00e9 (Reason: {})", (Object)info.getLabel(), (Object)e.getMessage());
                return false;
            }
        }
        logger.info("The {} plugin requires a restart of Prot\u00e9g\u00e9", (Object)info.getLabel());
        return false;
    }

    public static enum InstallerResult {
        DOWNLOADED,
        ERROR,
        INSTALLED;

    }
}

