/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hdfs.update;

import java.io.IOException;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.solr.common.util.FastInputStream;

class FSDataFastInputStream
extends FastInputStream {
    private final FSDataInputStream hdfsFis;

    public FSDataFastInputStream(FSDataInputStream hdfsFis, long chPosition) {
        super(null);
        this.hdfsFis = hdfsFis;
        this.readFromStream = chPosition;
    }

    public int readWrappedStream(byte[] target, int offset, int len) throws IOException {
        return this.hdfsFis.read(this.readFromStream, target, offset, len);
    }

    public void seek(long position) throws IOException {
        if (position <= this.readFromStream && position >= this.getBufferPos()) {
            this.pos = (int)(position - this.getBufferPos());
        } else {
            this.readFromStream = position;
            this.pos = 0;
            this.end = 0;
        }
        assert (this.position() == position);
    }

    public long getBufferPos() {
        return this.readFromStream - (long)this.end;
    }

    public int getBufferSize() {
        return this.buf.length;
    }

    public void close() throws IOException {
        this.hdfsFis.close();
    }

    public String toString() {
        return "readFromStream=" + this.readFromStream + " pos=" + this.pos + " end=" + this.end + " bufferPos=" + this.getBufferPos() + " position=" + this.position();
    }
}

