/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.packagemanager.PackageUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkMvTool
extends ToolBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public ZkMvTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_ZKHOST_DEPRECATED);
    }

    @Override
    public String getName() {
        return "mv";
    }

    @Override
    public String getUsage() {
        return "bin/solr zk mv [-s <HOST>] [-u <credentials>] [-v] [-z <HOST>] source destination";
    }

    @Override
    public String getHeader() {
        StringBuilder sb = new StringBuilder();
        PackageUtils.format(sb, "mv moves (renames) znodes on Zookeeper.");
        PackageUtils.format(sb, "");
        PackageUtils.format(sb, "<src>, <dest> : Zookeeper nodes, the 'zk:' prefix is optional.");
        PackageUtils.format(sb, "If <dest> ends with '/', then <dest> will be a parent znode");
        PackageUtils.format(sb, "and the last element of the <src> path will be appended.");
        PackageUtils.format(sb, "Zookeeper nodes CAN have data, so moving a single file to a parent znode");
        PackageUtils.format(sb, "will overlay the data on the parent Znode so specifying the trailing slash");
        PackageUtils.format(sb, "is important.");
        PackageUtils.format(sb, "\nList of options:");
        return sb.toString();
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String zkHost = SolrCLI.getZkHost(cli);
        try (SolrZkClient zkClient = SolrCLI.getSolrZkClient(cli, zkHost);){
            this.echoIfVerbose("\nConnecting to ZooKeeper at " + zkHost + " ...", cli);
            String src = cli.getArgs()[0];
            String dst = cli.getArgs()[1];
            if (src.toLowerCase(Locale.ROOT).startsWith("file:") || dst.toLowerCase(Locale.ROOT).startsWith("file:")) {
                throw new SolrServerException("mv command operates on znodes and 'file:' has been specified.");
            }
            String source = src;
            if (src.toLowerCase(Locale.ROOT).startsWith("zk")) {
                source = src.substring(3);
            }
            String dest = dst;
            if (dst.toLowerCase(Locale.ROOT).startsWith("zk")) {
                dest = dst.substring(3);
            }
            this.echo("Moving Znode " + source + " to " + dest + " on ZooKeeper at " + zkHost);
            zkClient.moveZnode(source, dest);
        }
        catch (Exception e) {
            log.error("Could not complete mv operation for reason: ", (Throwable)e);
            throw e;
        }
    }
}

