/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.util.List;
import java.util.Map;
import org.apache.solr.common.cloud.DocRouter;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.update.SolrIndexSplitter;
import org.apache.solr.update.UpdateCommand;

public class SplitIndexCommand
extends UpdateCommand {
    public final SolrQueryResponse rsp;
    public final List<String> paths;
    public final List<SolrCore> cores;
    public final List<DocRouter.Range> ranges;
    public final DocRouter router;
    public final String routeFieldName;
    public final String splitKey;
    public final SolrIndexSplitter.SplitMethod splitMethod;
    public Map<String, String> commitData;

    public SplitIndexCommand(SolrQueryRequest req, SolrQueryResponse rsp, List<String> paths, List<SolrCore> cores, List<DocRouter.Range> ranges, DocRouter router, String routeFieldName, String splitKey, SolrIndexSplitter.SplitMethod splitMethod) {
        super(req);
        this.rsp = rsp;
        this.paths = paths;
        this.cores = cores;
        this.ranges = ranges;
        this.router = router;
        this.routeFieldName = routeFieldName;
        this.splitKey = splitKey;
        this.splitMethod = splitMethod;
    }

    @Override
    public String name() {
        return "split";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append(",paths=").append(this.paths);
        sb.append(",cores=").append(this.cores);
        sb.append(",ranges=").append(this.ranges);
        sb.append(",router=").append(this.router);
        if (this.routeFieldName != null) {
            sb.append(",routeFieldName=").append(this.routeFieldName);
        }
        if (this.splitKey != null) {
            sb.append(",split.key=").append(this.splitKey);
        }
        sb.append(",method=").append(this.splitMethod.toLower());
        if (this.commitData != null) {
            sb.append(",commitData=").append(this.commitData);
        }
        sb.append('}');
        return sb.toString();
    }
}

