/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.instrumentation;

import org.graalvm.visualvm.lib.jfluid.classfile.DynamicClassInfo;
import org.graalvm.visualvm.lib.jfluid.client.RuntimeProfilingPoint;
import org.graalvm.visualvm.lib.jfluid.filters.InstrumentationFilter;
import org.graalvm.visualvm.lib.jfluid.global.CommonConstants;
import org.graalvm.visualvm.lib.jfluid.instrumentation.CPExtensionsRepository;
import org.graalvm.visualvm.lib.jfluid.instrumentation.ClassManager;
import org.graalvm.visualvm.lib.jfluid.instrumentation.CodeRegionEntryExitCallsInjector;
import org.graalvm.visualvm.lib.jfluid.instrumentation.HandleReflectInvokeCallInjector;
import org.graalvm.visualvm.lib.jfluid.instrumentation.HandleServletDoMethodCallInjector;
import org.graalvm.visualvm.lib.jfluid.instrumentation.Injector;
import org.graalvm.visualvm.lib.jfluid.instrumentation.MethodEntryExitCallsInjector;
import org.graalvm.visualvm.lib.jfluid.instrumentation.ObjLivenessInstrCallsInjector;
import org.graalvm.visualvm.lib.jfluid.instrumentation.ProfilePointHitCallInjector;

public class InstrumentationFactory
implements CommonConstants {
    public static byte[] instrumentAsProiflePointHitMethod(DynamicClassInfo clazz, int methodIdx, int injType, RuntimeProfilingPoint[] points) {
        ProfilePointHitCallInjector mi = new ProfilePointHitCallInjector(clazz, clazz.getBaseCPoolCount(injType), methodIdx, points, CPExtensionsRepository.normalContents_ProfilePointHitMethodIdx);
        return ((Injector)mi).instrumentMethod();
    }

    public static byte[] instrumentAsReflectInvokeMethod(DynamicClassInfo clazz, int methodIdx) {
        HandleReflectInvokeCallInjector mi = new HandleReflectInvokeCallInjector(clazz, clazz.getBaseCPoolCount(6), methodIdx);
        return ((Injector)mi).instrumentMethod();
    }

    public static byte[] instrumentAsServletDoMethod(DynamicClassInfo clazz, int methodIdx) {
        HandleServletDoMethodCallInjector mi = new HandleServletDoMethodCallInjector(clazz, clazz.getBaseCPoolCount(7), methodIdx);
        return ((Injector)mi).instrumentMethod();
    }

    public static byte[] instrumentCodeRegion(DynamicClassInfo clazz, int methodIdx, int bci0, int bci1) {
        CodeRegionEntryExitCallsInjector mi = new CodeRegionEntryExitCallsInjector(clazz, clazz.getBaseCPoolCount(8), methodIdx, bci0, bci1);
        return ((Injector)mi).instrumentMethod();
    }

    public static byte[] instrumentForMemoryProfiling(ClassManager man, DynamicClassInfo clazz, int methodIdx, boolean[] allUnprofiledClassStatusArray, int injType, RuntimeProfilingPoint[] points, InstrumentationFilter instrFilter, boolean checkForOpcNew, boolean checkForOpcNewArray) {
        ObjLivenessInstrCallsInjector mi = new ObjLivenessInstrCallsInjector(man, clazz, clazz.getBaseCPoolCount(injType), methodIdx, allUnprofiledClassStatusArray, instrFilter, checkForOpcNew, checkForOpcNewArray);
        mi.insertProfilingPoints(points, CPExtensionsRepository.memoryProfContents_ProfilePointHitMethodIdx);
        return ((Injector)mi).instrumentMethod();
    }

    public static byte[] instrumentMethod(DynamicClassInfo clazz, int methodIdx, int normalInjectionType, int rootInjectionType, int markerInjectionType, int methodId, RuntimeProfilingPoint[] points) {
        int injType;
        int baseCPCount1;
        int baseCPCount0 = clazz.getBaseCPoolCount(normalInjectionType);
        if (clazz.isMethodRoot(methodIdx)) {
            baseCPCount1 = clazz.getBaseCPoolCount(rootInjectionType);
            injType = rootInjectionType;
        } else if (clazz.isMethodMarker(methodIdx)) {
            baseCPCount1 = clazz.getBaseCPoolCount(markerInjectionType);
            injType = markerInjectionType;
        } else {
            baseCPCount1 = 0;
            injType = normalInjectionType;
        }
        MethodEntryExitCallsInjector mi = new MethodEntryExitCallsInjector(clazz, baseCPCount0, baseCPCount1, methodIdx, injType, methodId);
        mi.insertProfilingPoints(points, CPExtensionsRepository.normalContents_ProfilePointHitMethodIdx);
        byte[] res = ((Injector)mi).instrumentMethod();
        clazz.setInstrMethodId(methodIdx, methodId);
        return res;
    }
}

