/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.stats;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zaproxy.zap.utils.Statistics;
import org.zaproxy.zap.utils.StatsListener;

public class InMemoryStats
implements StatsListener {
    private Statistics stats = new Statistics();
    private Map<String, Statistics> siteStats = new HashMap<String, Statistics>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Statistics getStatistics(String site) {
        if (site == null) {
            return this.stats;
        }
        if (!this.siteStats.containsKey(site)) {
            Map<String, Statistics> map = this.siteStats;
            synchronized (map) {
                if (!this.siteStats.containsKey(site)) {
                    this.siteStats.put(site, new Statistics());
                }
            }
        }
        return this.siteStats.get(site);
    }

    @Override
    public void counterInc(String key) {
        this.counterInc(null, key);
    }

    @Override
    public void counterInc(String site, String key) {
        this.getStatistics(site).incCounter(key);
    }

    @Override
    public void counterInc(String key, long inc) {
        this.counterInc(null, key, inc);
    }

    @Override
    public void counterInc(String site, String key, long inc) {
        this.getStatistics(site).incCounter(key, inc);
    }

    @Override
    public void counterDec(String key) {
        this.counterDec(null, key);
    }

    @Override
    public void counterDec(String site, String key) {
        this.getStatistics(site).decCounter(key);
    }

    @Override
    public void counterDec(String key, long dec) {
        this.counterDec(null, key, dec);
    }

    @Override
    public void counterDec(String site, String key, long dec) {
        this.getStatistics(site).decCounter(key, dec);
    }

    @Override
    public void highwaterMarkSet(String key, long value) {
        this.highwaterMarkSet(null, key, value);
    }

    @Override
    public void highwaterMarkSet(String site, String key, long value) {
        this.getStatistics(site).setHighwaterMark(key, value);
    }

    @Override
    public void lowwaterMarkSet(String key, long value) {
        this.lowwaterMarkSet(null, key, value);
    }

    @Override
    public void lowwaterMarkSet(String site, String key, long value) {
        this.getStatistics(site).setLowwaterMark(key, value);
    }

    @Override
    public void allCleared() {
        this.stats.clearAll();
        for (Statistics st : this.siteStats.values()) {
            st.clearAll();
        }
        this.siteStats.clear();
    }

    @Override
    public void allCleared(String site) {
        this.getStatistics(site).clearAll();
    }

    @Override
    public void cleared(String keyPrefix) {
        this.stats.clear(keyPrefix);
        for (Statistics st : this.siteStats.values()) {
            st.clear(keyPrefix);
        }
    }

    @Override
    public void cleared(String site, String keyPrefix) {
        this.getStatistics(site).clear(keyPrefix);
    }

    public Long getStat(String key) {
        return this.stats.getStat(key);
    }

    public Long getStat(String site, String key) {
        if (site == null || this.siteStats.containsKey(site)) {
            return this.getStatistics(site).getStat(key);
        }
        return null;
    }

    public Map<String, Long> getStats(String keyPrefix) {
        return this.stats.getStats(keyPrefix);
    }

    public Map<String, Map<String, Long>> getAllSiteStats(String keyPrefix) {
        HashMap<String, Map<String, Long>> allStats = new HashMap<String, Map<String, Long>>();
        for (Map.Entry<String, Statistics> st : this.siteStats.entrySet()) {
            allStats.put(st.getKey(), st.getValue().getStats(keyPrefix));
        }
        return allStats;
    }

    public Map<String, Long> getSiteStats(String site, String keyPrefix) {
        if (this.siteStats.containsKey(site)) {
            return this.getStatistics(site).getStats(keyPrefix);
        }
        return new HashMap<String, Long>();
    }

    public List<String> getSites() {
        ArrayList<String> sites = new ArrayList<String>(this.siteStats.keySet());
        Collections.sort(sites);
        return sites;
    }
}

