/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.exceptions;

import oracle.eclipselink.coherence.logging.MessageGenerator;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.sessions.Session;

public class IntegrationException
extends EclipseLinkException {
    public static final int UNABLE_TO_FIND_COHERENCE_CACHE = 80000;
    public static final int OPTIMISTIC_LOCKING_POLICY_NOT_SUPPORTED = 80001;
    public static final int UNABLE_TO_FIND_DESCRIPTOR = 80002;
    public static final int UNABLE_TO_DEFINE_WRAPPER_CLASS_ON_CLASSLOADER = 80003;
    public static final int UNABLE_TO_ACCESS_DEFINECLASS_METHOD_OF_CLASSLOADER = 80004;
    public static final int ECLIPSELINKSERIALIZER_NOT_SET_AS_CACHE_SERIALIZER = 80005;
    public static final int FAILED_TO_LOAD_WRAPPER_CLASS = 80006;
    public static final int FAILED_TO_CREATE_INSTANCE_OF_WRAPPER = 80007;
    public static final int MAPPING_VALUES_NOT_SET_IN_WRAPPER = 80008;
    public static final int UNABLE_TO_EVALUATE_SUBCLASS_FILTER = 80009;
    public static final int UNABLE_TO_INSTANTIATE_FILTER_FACTORY = 80010;
    public static final int UNABLE_TO_INSTANTIATE_FAILOVER_POLICY = 80011;
    public static final int FK_RELATIONSHIPS_NOT_SUPPORTED_IN_ELEMENT_COLLECTION_ELEMENTS = 80012;
    public static final int COMPONENT_ENTITY_CAN_BE_MEMBER_OF_ONE_GRAPH = 80013;
    public static final int ONLY_ONE_ROOT_IN_ENTITY_GRAPH = 80014;
    public static final int FAILURE_DURING_SERIALIZATION = 80015;
    public static final int NO_PU_FOUND = 80016;
    public static final int NOT_ECLIPSELINK_PROVIDER = 80017;

    public IntegrationException(String message) {
        super(message);
    }

    public IntegrationException(String message, Throwable cause) {
        super(message, cause);
    }

    public static IntegrationException unableToInstantiateFailoverPolicy(String className, Exception rootException) {
        Object[] args = new Object[]{className};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80011, args));
        integrationException.setErrorCode(80011);
        integrationException.setInternalException(rootException);
        return integrationException;
    }

    public static IntegrationException unableToInstantiateFilterFactory(String className, Exception rootException) {
        Object[] args = new Object[]{className};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80010, args));
        integrationException.setErrorCode(80010);
        integrationException.setInternalException(rootException);
        return integrationException;
    }

    public static IntegrationException unableToFindCoherenceCache(String cacheName, Exception rootException) {
        Object[] args = new Object[]{cacheName};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80000, args));
        integrationException.setErrorCode(80000);
        integrationException.setInternalException(rootException);
        return integrationException;
    }

    public static IntegrationException optimisticLockingPolicyNotSupported(String javaClass) {
        Object[] args = new Object[]{javaClass};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80001, args));
        integrationException.setErrorCode(80001);
        return integrationException;
    }

    public static IntegrationException unableToFindDescriptor(String cacheName, Session session) {
        Object[] args = new Object[]{cacheName, session.getName()};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80002, args));
        integrationException.setErrorCode(80002);
        return integrationException;
    }

    public static IntegrationException unableToDefineGeneratedWrapperClass(String className, Exception rootException) {
        Object[] args = new Object[]{className};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80003, args));
        integrationException.setErrorCode(80003);
        integrationException.setInternalException(rootException);
        return integrationException;
    }

    public static IntegrationException unableToAccessDefineClassMethodOfClassLader(Exception rootException) {
        Object[] args = new Object[]{};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80004, args));
        integrationException.setErrorCode(80004);
        integrationException.setInternalException(rootException);
        return integrationException;
    }

    public static IntegrationException serializerNotSetToEclipseLinkSerializer(String className, String cacheName) {
        Object[] args = new Object[]{className, cacheName};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80005, args));
        integrationException.setErrorCode(80005);
        return integrationException;
    }

    public static IntegrationException failedToLoadWrapperClass(String wrapperName, Exception rootException) {
        Object[] args = new Object[]{wrapperName};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80006, args));
        integrationException.setErrorCode(80006);
        integrationException.setInternalException(rootException);
        return integrationException;
    }

    public static IntegrationException failedToCreateWrapperInstance(String wrapperName, Exception rootException) {
        Object[] args = new Object[]{wrapperName};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80007, args));
        integrationException.setErrorCode(80007);
        integrationException.setInternalException(rootException);
        return integrationException;
    }

    public static IntegrationException mappingValuesNotSent(String attributeName, String className) {
        Object[] args = new Object[]{attributeName, className};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80008, args));
        integrationException.setErrorCode(80008);
        return integrationException;
    }

    public static IntegrationException noClassFoundSubClassFilter(String className, ClassLoader loader, Throwable cause) {
        Object[] args = new Object[]{className, loader};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80009, args), cause);
        integrationException.setErrorCode(80009);
        return integrationException;
    }

    public static IntegrationException relationshipFromElementCollectionEmbeddablesNotSupported() {
        Object[] args = new Object[]{};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80012, args));
        integrationException.setErrorCode(80012);
        return integrationException;
    }

    public static IntegrationException componentEntityCanBeMemberOfOnlyOneGraph(String parentEntity, String targetType, String existingRoot) {
        Object[] args = new Object[]{parentEntity, targetType, existingRoot};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80013, args));
        integrationException.setErrorCode(80013);
        return integrationException;
    }

    public static IntegrationException onlyOneRootIsAllowedInEntityGraph(String rootClassName, String sourceClassName) {
        Object[] args = new Object[]{rootClassName, sourceClassName};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80014, args));
        integrationException.setErrorCode(80014);
        return integrationException;
    }

    public static IntegrationException failureDuringObjectSerialization(Class type, String fieldName, Throwable exception) {
        Object[] args = new Object[]{type.getName(), fieldName, exception.toString()};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80015, args), exception);
        integrationException.setErrorCode(80015);
        return integrationException;
    }

    public static IntegrationException unableToFindPersistenceUnit(String puName) {
        Object[] args = new Object[]{puName};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80016, args));
        integrationException.setErrorCode(80016);
        return integrationException;
    }

    public static IntegrationException notEclipseLinkProvider() {
        Object[] args = new Object[]{};
        IntegrationException integrationException = new IntegrationException(MessageGenerator.buildMessage(IntegrationException.class, 80017, args));
        integrationException.setErrorCode(80017);
        return integrationException;
    }
}

