/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.cache;

import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.WriteBuffer;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import oracle.eclipselink.coherence.integrated.internal.cache.ClassLoaderAwareImpl;
import oracle.eclipselink.coherence.integrated.internal.cache.SerializableWrapper;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperGenerator;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperInternal;

public class WrapperSerializer
extends ClassLoaderAwareImpl
implements Serializer {
    protected static final Map<ClassLoader, WrapperSerializer> mapSerializerByClassLoader = Collections.synchronizedMap(new WeakHashMap());
    protected Map<String, Class> classes = new HashMap<String, Class>();
    protected boolean isNotEclipseLink = System.getProperty("eclipselink.coherence.not-eclipselink") != null;

    public boolean isNotEclipseLink() {
        return this.isNotEclipseLink;
    }

    public void setNotEclipseLink(boolean isNotEclipseLink) {
        this.isNotEclipseLink = isNotEclipseLink;
    }

    public WrapperSerializer() {
    }

    public WrapperSerializer(ClassLoader loader) {
        this();
        this.setContextClassLoader(loader);
    }

    public void serialize(WriteBuffer.BufferOutput out, Object o) throws IOException {
        if (o instanceof WrapperInternal && !(o instanceof SerializableWrapper)) {
            o = new SerializableWrapper((WrapperInternal)o);
        }
        ExternalizableHelper.writeObject((DataOutput)out, (Object)o);
    }

    public Object deserialize(ReadBuffer.BufferInput in) throws IOException {
        Object serialized = ExternalizableHelper.readObject((DataInput)in, (ClassLoader)this.getContextClassLoader());
        if (serialized instanceof SerializableWrapper) {
            return this.deserialize((SerializableWrapper)serialized);
        }
        return serialized;
    }

    public static Object deserialize(Object target, Object received) throws IOException {
        if (received instanceof SerializableWrapper) {
            ClassLoader loader = ExternalizableHelper.getContextClassLoader((Object)target);
            return WrapperSerializer.deserialize(loader, (SerializableWrapper)received);
        }
        return received;
    }

    public static Object deserialize(ClassLoader loader, SerializableWrapper received) throws IOException {
        return WrapperSerializer.ensureSerializer(loader).deserialize(received);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deserialize(SerializableWrapper received) throws IOException {
        if (this.isNotEclipseLink) {
            return received.unwrap();
        }
        Class<?> wrapperClass = this.classes.get(received.getWrapperClassName());
        if (wrapperClass == null) {
            Map<String, Class> map = this.classes;
            synchronized (map) {
                try {
                    wrapperClass = Class.forName(received.getWrapperClassName(), false, this.getContextClassLoader());
                }
                catch (ClassNotFoundException ex) {
                    WrapperGenerator generator = new WrapperGenerator();
                    generator.createWrapperFor(received.unwrap().getClass(), this.getContextClassLoader());
                    try {
                        wrapperClass = Class.forName(received.getWrapperClassName(), false, this.getContextClassLoader());
                    }
                    catch (ClassNotFoundException ex2) {
                        return received.unwrap();
                    }
                }
                this.classes.put(received.getWrapperClassName(), wrapperClass);
            }
        }
        Object serialized = received;
        boolean exception = false;
        try {
            WrapperInternal newWrapper = (WrapperInternal)wrapperClass.newInstance();
            newWrapper.setForeignKeys(received.getForeignKeys());
            newWrapper.setPrimaryKeys(received.getPrimaryKeys());
            newWrapper.setFetchedAttributeNames(received.getFetchedAttributeNames());
            newWrapper.wrap(received.unwrap());
            serialized = newWrapper;
        }
        catch (InstantiationException e) {
            exception = true;
        }
        catch (IllegalAccessException e) {
            exception = true;
        }
        if (exception) {
            serialized = received.unwrap();
        }
        return serialized;
    }

    public static Object serialize(Object object) {
        if (object instanceof WrapperInternal && !(object instanceof SerializableWrapper)) {
            object = new SerializableWrapper((WrapperInternal)object);
        }
        return object;
    }

    public static WrapperSerializer ensureSerializer(ClassLoader loader) {
        Map<ClassLoader, WrapperSerializer> map = mapSerializerByClassLoader;
        WrapperSerializer serializer = map.get(loader);
        if (serializer == null) {
            serializer = new WrapperSerializer(loader);
            map.put(loader, serializer);
        }
        return serializer;
    }
}

