/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.cache;

import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.cache.ReadWriteBackingMap;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import oracle.eclipselink.coherence.integrated.cache.TopLinkGridPortableObject;
import oracle.eclipselink.coherence.integrated.internal.cache.CoherenceCacheHelper;
import oracle.eclipselink.coherence.integrated.internal.cache.SerializationHelper;
import oracle.eclipselink.coherence.integrated.internal.cache.WrapperInternal;
import org.eclipse.persistence.mappings.AttributeAccessor;

public class ElementCollectionUpdateProcessor
extends AbstractProcessor
implements ExternalizableLite,
PortableObject,
TopLinkGridPortableObject {
    protected Object attributeValue;
    protected AttributeAccessor[] attributeAccessors;
    protected Object versionValue;
    protected AttributeAccessor versionAccessor;
    protected String attributeName;

    public ElementCollectionUpdateProcessor() {
    }

    public ElementCollectionUpdateProcessor(Object attributeValue, AttributeAccessor[] attributeAccessors, Object versionValue, AttributeAccessor versionAccessor, String attributeName) {
        this.attributeValue = attributeValue;
        this.attributeAccessors = attributeAccessors;
        this.versionValue = versionValue;
        this.versionAccessor = versionAccessor;
        this.attributeName = attributeName;
    }

    public Object process(InvocableMap.Entry entry) {
        if (entry.isPresent()) {
            AttributeAccessor attributeAccessor;
            Comparable entryVersionValue;
            if (this.versionAccessor != null && (entryVersionValue = (Comparable)CoherenceCacheHelper.getVersionFromBinaryEntry((BinaryEntry)entry, this.versionAccessor)) != null && entryVersionValue.compareTo(this.versionValue) != 0) {
                return null;
            }
            WrapperInternal wrapper = (WrapperInternal)entry.getValue();
            Object object = wrapper.unwrap();
            int length = this.attributeAccessors.length - 1;
            int index = 0;
            Object nested = object;
            while (index < length) {
                if (!(attributeAccessor = this.attributeAccessors[index++]).isInitialized()) {
                    attributeAccessor.initializeAttributes(nested.getClass());
                }
                nested = attributeAccessor.getAttributeValueFromObject(nested);
            }
            attributeAccessor = this.attributeAccessors[index];
            if (!attributeAccessor.isInitialized()) {
                attributeAccessor.initializeAttributes(nested.getClass());
            }
            attributeAccessor.setAttributeValueInObject(nested, this.attributeValue);
            wrapper.getForeignKeys().remove(this.attributeName);
            if (((BinaryEntry)entry).getBackingMap() instanceof ReadWriteBackingMap) {
                Converter valueConvertor = ((BinaryEntry)entry).getContext().getValueToInternalConverter();
                Object convertedValue = valueConvertor.convert((Object)wrapper);
                ((ReadWriteBackingMap)((BinaryEntry)entry).getBackingMap()).getInternalCache().put((Object)((BinaryEntry)entry).getBinaryKey(), convertedValue);
            } else {
                entry.setValue((Object)wrapper, true);
            }
        }
        return null;
    }

    public Map processAll(Set setEntries) {
        return null;
    }

    public void readExternal(DataInput in) throws IOException {
        this.attributeValue = ExternalizableHelper.readObject((DataInput)in);
        this.versionValue = ExternalizableHelper.readObject((DataInput)in);
        this.versionAccessor = SerializationHelper.readAttributeAccessor(in);
        this.attributeAccessors = SerializationHelper.readAttributeAccessorArray(in);
        this.attributeName = (String)ExternalizableHelper.readObject((DataInput)in);
    }

    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.attributeValue);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.versionValue);
        SerializationHelper.writeAttributeAccessor(out, this.versionAccessor);
        SerializationHelper.writeAttributeAccessorArray(out, this.attributeAccessors);
        ExternalizableHelper.writeObject((DataOutput)out, (Object)this.attributeName);
    }

    public void readExternal(PofReader in) throws IOException {
        this.attributeValue = in.readObject(0);
        this.versionValue = in.readObject(1);
        this.versionAccessor = SerializationHelper.readAttributeAccessor(in.createNestedPofReader(2));
        this.attributeAccessors = SerializationHelper.readAttributeAccessorArray(in.createNestedPofReader(3));
        this.attributeName = in.readString(4);
    }

    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.attributeValue);
        out.writeObject(1, this.versionValue);
        SerializationHelper.writeAttributeAccessor(out.createNestedPofWriter(2), this.versionAccessor);
        SerializationHelper.writeAttributeAccessorArray(out.createNestedPofWriter(3), this.attributeAccessors);
        out.writeString(4, this.attributeName);
    }
}

