/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.querying;

import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableLite;
import com.tangosol.util.Filter;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.aggregator.BigDecimalAverage;
import com.tangosol.util.aggregator.BigDecimalMax;
import com.tangosol.util.aggregator.BigDecimalMin;
import com.tangosol.util.aggregator.BigDecimalSum;
import com.tangosol.util.aggregator.ComparableMax;
import com.tangosol.util.aggregator.ComparableMin;
import com.tangosol.util.aggregator.Count;
import com.tangosol.util.aggregator.DoubleAverage;
import com.tangosol.util.aggregator.DoubleMax;
import com.tangosol.util.aggregator.DoubleMin;
import com.tangosol.util.aggregator.DoubleSum;
import com.tangosol.util.aggregator.LongMax;
import com.tangosol.util.aggregator.LongMin;
import com.tangosol.util.aggregator.LongSum;
import com.tangosol.util.extractor.IdentityExtractor;
import com.tangosol.util.filter.AllFilter;
import com.tangosol.util.filter.AlwaysFilter;
import com.tangosol.util.filter.AnyFilter;
import com.tangosol.util.filter.BetweenFilter;
import com.tangosol.util.filter.EqualsFilter;
import com.tangosol.util.filter.GreaterEqualsFilter;
import com.tangosol.util.filter.GreaterFilter;
import com.tangosol.util.filter.InFilter;
import com.tangosol.util.filter.LessEqualsFilter;
import com.tangosol.util.filter.LessFilter;
import com.tangosol.util.filter.LikeFilter;
import com.tangosol.util.filter.NotFilter;
import com.tangosol.util.processor.ExtractorProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.WeakHashMap;
import oracle.eclipselink.coherence.exceptions.IntegrationException;
import oracle.eclipselink.coherence.integrated.cache.TopLinkGridPortableObject;
import oracle.eclipselink.coherence.integrated.cache.Wrapper;
import oracle.eclipselink.coherence.integrated.internal.querying.FilterExtractor;
import oracle.eclipselink.coherence.integrated.querying.FilterFactory;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.expressions.ConstantExpression;
import org.eclipse.persistence.internal.expressions.FieldExpression;
import org.eclipse.persistence.internal.expressions.FunctionExpression;
import org.eclipse.persistence.internal.expressions.LogicalExpression;
import org.eclipse.persistence.internal.expressions.ParameterExpression;
import org.eclipse.persistence.internal.expressions.QueryKeyExpression;
import org.eclipse.persistence.internal.expressions.RelationExpression;
import org.eclipse.persistence.internal.helper.BasicTypeHelperImpl;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class EclipseLinkFilterFactory
implements FilterFactory {
    protected static Map<Expression, Filter> expressionCache = new WeakHashMap<Expression, Filter>();

    @Override
    public Filter create(ObjectLevelReadQuery query, Record args, Session session) {
        ReadAllQuery localQuery;
        if (!query.getJoinedAttributeExpressions().isEmpty() || query.getLockMode() > 0 || query.getAsOfClause() != null) {
            return NO_FILTER;
        }
        if (query.isReadAllQuery() && !(localQuery = (ReadAllQuery)query).getOrderByExpressions().isEmpty()) {
            return NO_FILTER;
        }
        Expression expression = query.getSelectionCriteria();
        Filter cachedFilter = null;
        if (query.isCustomQueryUsed() != null && query.isCustomQueryUsed().booleanValue()) {
            cachedFilter = expressionCache.get(expression);
        }
        if (cachedFilter != null) {
            if (cachedFilter == NO_FILTER) {
                return null;
            }
            return cachedFilter;
        }
        query.getExpressionBuilder().setSession((AbstractSession)session);
        query.getExpressionBuilder().setQueryClass(query.getReferenceClass());
        cachedFilter = this.create(expression, args, (AbstractSession)session);
        if (cachedFilter == null) {
            cachedFilter = NO_FILTER;
            if (query.isCustomQueryUsed() != null && query.isCustomQueryUsed().booleanValue() || query.getName() != null) {
                expressionCache.put(expression, NO_FILTER);
            }
        } else {
            if (query.getDescriptor().hasInheritance()) {
                ArrayList<Filter> filters = new ArrayList<Filter>();
                this.flattenAllFilters(filters, cachedFilter);
                this.flattenAllFilters(filters, new SubClassOf(query.getReferenceClass()));
                cachedFilter = new AllFilter(filters.toArray(new Filter[filters.size()]));
            }
            if (query.isCustomQueryUsed() != null && query.isCustomQueryUsed().booleanValue() || query.getName() != null) {
                expressionCache.put(expression, cachedFilter);
            }
        }
        return cachedFilter;
    }

    protected Filter create(Expression expression, Record args, AbstractSession session) {
        if (expression == null) {
            return new AlwaysFilter();
        }
        if (expression.isLogicalExpression()) {
            return this.createLogical((LogicalExpression)expression, args, session);
        }
        if (expression.isRelationExpression()) {
            RelationExpression relExp = (RelationExpression)expression;
            switch (relExp.getOperator().getSelector()) {
                case 4: {
                    return this.createEquals(relExp, args, session);
                }
                case 5: {
                    return this.createNotEquals(relExp, args, session);
                }
                case 9: {
                    return this.createGreaterThan(relExp, args, session);
                }
                case 10: {
                    return this.createGreaterThanEquals(relExp, args, session);
                }
                case 7: {
                    return this.createLessThan(relExp, args, session);
                }
                case 8: {
                    return this.createLessThanEquals(relExp, args, session);
                }
                case 13: {
                    return this.createIn(relExp, args, session);
                }
            }
        }
        if (expression.isFunctionExpression()) {
            FunctionExpression funcExp = (FunctionExpression)expression;
            switch (funcExp.getOperator().getSelector()) {
                case 17: {
                    return this.createIsNull(funcExp, session);
                }
                case 18: {
                    return this.createNotNull(funcExp, session);
                }
                case 15: {
                    return this.createBetween(funcExp, session);
                }
                case 11: {
                    return this.createLike(funcExp, args, session);
                }
            }
        }
        session.log(6, "query", "expression_not_supported_by_filter_factory");
        return null;
    }

    protected Filter createLogical(LogicalExpression expression, Record args, AbstractSession session) {
        switch (expression.getOperator().getSelector()) {
            case 1: {
                return this.createAnd(expression, args, session);
            }
            case 2: {
                return this.createOr(expression, args, session);
            }
        }
        throw new IllegalArgumentException("ExpressionFilterConverter.createLogical::failed with unknown logical expression: " + expression);
    }

    protected AllFilter createAnd(LogicalExpression expression, Record args, AbstractSession session) {
        Filter leftFilter = this.create(expression.getFirstChild(), args, session);
        Filter rightFilter = this.create(expression.getSecondChild(), args, session);
        if (leftFilter != null && rightFilter != null) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            this.flattenAllFilters(filters, leftFilter);
            this.flattenAllFilters(filters, rightFilter);
            return new AllFilter(filters.toArray(new Filter[filters.size()]));
        }
        return null;
    }

    private void flattenAllFilters(List<Filter> filters, Filter filter) {
        if (filter instanceof AllFilter) {
            AllFilter allFilter = (AllFilter)filter;
            Filter[] allFilters = allFilter.getFilters();
            for (int i = 0; i < allFilters.length; ++i) {
                Filter eachFilter = allFilters[i];
                filters.add(eachFilter);
            }
        } else {
            filters.add(filter);
        }
    }

    protected AnyFilter createOr(LogicalExpression expression, Record args, AbstractSession session) {
        Filter leftFilter = this.create(expression.getFirstChild(), args, session);
        Filter rightFilter = this.create(expression.getSecondChild(), args, session);
        if (leftFilter != null && rightFilter != null) {
            ArrayList<Filter> filters = new ArrayList<Filter>();
            this.flattenOrFilters(filters, leftFilter);
            this.flattenOrFilters(filters, rightFilter);
            return new AnyFilter(filters.toArray(new Filter[filters.size()]));
        }
        return null;
    }

    private void flattenOrFilters(List<Filter> filters, Filter filter) {
        if (filter instanceof AnyFilter) {
            AnyFilter allFilter = (AnyFilter)filter;
            Filter[] allFilters = allFilter.getFilters();
            for (int i = 0; i < allFilters.length; ++i) {
                Filter eachFilter = allFilters[i];
                filters.add(eachFilter);
            }
        } else {
            filters.add(filter);
        }
    }

    protected IsNull createIsNull(FunctionExpression expression, AbstractSession session) {
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getBaseExpression().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getBaseExpression()), session)) != null) {
            return new IsNull((ValueExtractor)extractor);
        }
        return null;
    }

    protected IsNotNull createNotNull(FunctionExpression expression, AbstractSession session) {
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getBaseExpression().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getBaseExpression()), session)) != null) {
            return new IsNotNull((ValueExtractor)extractor);
        }
        return null;
    }

    protected BetweenFilter createBetween(FunctionExpression expression, AbstractSession session) {
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getBaseExpression().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getBaseExpression()), session)) != null) {
            Comparable upperValue;
            Comparable lowerValue;
            try {
                ConstantExpression lower = (ConstantExpression)expression.getChildren().get(1);
                ConstantExpression upper = (ConstantExpression)expression.getChildren().get(2);
                lowerValue = (Comparable)lower.getValue();
                lowerValue = (Comparable)session.getPlatform().convertObject((Object)lowerValue, extractor.getAttributeClass());
                upperValue = (Comparable)upper.getValue();
                upperValue = (Comparable)session.getPlatform().convertObject((Object)upperValue, extractor.getAttributeClass());
            }
            catch (ClassCastException e) {
                session.log(6, "query", "Failed to convert query: " + expression.toString() + " to Coherence filter: between() expression only supports constant numberic values.", (Object[])null, null, false);
                return null;
            }
            return new BetweenFilter((ValueExtractor)extractor, lowerValue, upperValue);
        }
        return null;
    }

    protected EqualsFilter createEquals(RelationExpression expression, Record args, AbstractSession session) {
        Object value;
        FilterExtractor extractor = this.createValueExtractor(expression.getFirstChild(), session);
        if (extractor != null && (value = this.getValue(expression.getSecondChild(), args, session, extractor.getAttributeClass())) != null) {
            return new EqualsFilter((ValueExtractor)extractor, value);
        }
        return null;
    }

    protected NotFilter createNotEquals(RelationExpression expression, Record args, AbstractSession session) {
        Object value;
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getFirstChild().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getFirstChild()), session)) != null && (value = this.getValue(expression.getSecondChild(), args, session, extractor.getAttributeClass())) != null) {
            return new NotFilter((Filter)new EqualsFilter((ValueExtractor)extractor, value));
        }
        return null;
    }

    protected LessFilter createLessThan(RelationExpression expression, Record args, AbstractSession session) {
        Object value;
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getFirstChild().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getFirstChild()), session)) != null && (value = this.getValue(expression.getSecondChild(), args, session, extractor.getAttributeClass())) != null) {
            return new LessFilter((ValueExtractor)extractor, (Comparable)value);
        }
        return null;
    }

    protected LessEqualsFilter createLessThanEquals(RelationExpression expression, Record args, AbstractSession session) {
        Object value;
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getFirstChild().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getFirstChild()), session)) != null && (value = this.getValue(expression.getSecondChild(), args, session, extractor.getAttributeClass())) != null) {
            return new LessEqualsFilter((ValueExtractor)extractor, (Comparable)value);
        }
        return null;
    }

    protected GreaterFilter createGreaterThan(RelationExpression expression, Record args, AbstractSession session) {
        Object value;
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getFirstChild().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getFirstChild()), session)) != null && (value = this.getValue(expression.getSecondChild(), args, session, extractor.getAttributeClass())) != null) {
            return new GreaterFilter((ValueExtractor)extractor, (Comparable)value);
        }
        return null;
    }

    protected GreaterEqualsFilter createGreaterThanEquals(RelationExpression expression, Record args, AbstractSession session) {
        Object value;
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getFirstChild().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getFirstChild()), session)) != null && (value = this.getValue(expression.getSecondChild(), args, session, extractor.getAttributeClass())) != null) {
            return new GreaterEqualsFilter((ValueExtractor)extractor, (Comparable)value);
        }
        return null;
    }

    protected LikeFilter createLike(FunctionExpression expression, Record args, AbstractSession session) {
        if (expression.getChildren().size() > 2) {
            return null;
        }
        if (((Expression)expression.getChildren().get(0)).isQueryKeyExpression()) {
            QueryKeyExpression qkExp = (QueryKeyExpression)expression.getChildren().get(0);
            FilterExtractor extractor = this.createValueExtractor((Expression)qkExp, session);
            String pattern = (String)this.getValue((Expression)expression.getChildren().get(1), args, session, ClassConstants.STRING);
            if (extractor != null) {
                return new LikeFilter((ValueExtractor)extractor, pattern, '\\', false);
            }
        }
        return null;
    }

    protected InFilter createIn(RelationExpression expression, Record args, AbstractSession session) {
        Vector values;
        QueryKeyExpression qkExp;
        FilterExtractor extractor;
        if (expression.getFirstChild().isQueryKeyExpression() && (extractor = this.createValueExtractor((Expression)(qkExp = (QueryKeyExpression)expression.getFirstChild()), session)) != null && (values = (Vector)this.getValue(expression.getSecondChild(), args, session, extractor.getAttributeClass())) != null) {
            return new InFilter((ValueExtractor)extractor, new HashSet(values));
        }
        return null;
    }

    protected Object getValue(Expression expression, Record args, AbstractSession session, Class targetClass) {
        DatabaseField field;
        if (expression.isConstantExpression()) {
            Object value = ((ConstantExpression)expression).getValue();
            if (value instanceof Collection) {
                Collection newValue;
                try {
                    newValue = (Collection)value.getClass().newInstance();
                }
                catch (InstantiationException e) {
                    session.log(6, "query", "Instantiation exception when converting collection parameter: " + expression + " with args: " + args, (Object[])null, null, false);
                    return null;
                }
                catch (IllegalAccessException e) {
                    session.log(6, "query", "IllegalAccessException when converting collection parameter: " + expression + " with args: " + args, (Object[])null, null, false);
                    return null;
                }
                Iterator iterator = ((Collection)value).iterator();
                while (iterator.hasNext()) {
                    newValue.add(session.getPlatform().convertObject(iterator.next(), targetClass));
                }
                return newValue;
            }
            return session.getPlatform().convertObject(value, targetClass);
        }
        if (expression.isParameterExpression() && session.getDescriptor(targetClass) == null && args.containsKey((Object)(field = ((ParameterExpression)expression).getField()))) {
            Object value = args.get((Object)field);
            if (value instanceof Collection) {
                Collection newValue;
                try {
                    newValue = (Collection)value.getClass().newInstance();
                }
                catch (InstantiationException e) {
                    session.log(6, "query", "Instantiation exception when converting collection parameter: " + expression + " with args: " + args, (Object[])null, null, false);
                    return null;
                }
                catch (IllegalAccessException e) {
                    session.log(6, "query", "IllegalAccessException when converting collection parameter: " + expression + " with args: " + args, (Object[])null, null, false);
                    return null;
                }
                Iterator iterator = ((Collection)value).iterator();
                while (iterator.hasNext()) {
                    newValue.add(session.getPlatform().convertObject(iterator.next(), targetClass));
                }
                return newValue;
            }
            return session.getPlatform().convertObject(value, targetClass);
        }
        session.log(6, "query", "FilterFactory.getValue does not support: " + expression + " with args: " + args, (Object[])null, null, false);
        return null;
    }

    @Override
    public FilterExtractor createValueExtractor(Expression expression, AbstractSession session) {
        if (expression.isQueryKeyExpression()) {
            QueryKeyExpression qkExp = (QueryKeyExpression)expression;
            if (qkExp.getBaseExpression() != null && !qkExp.getBaseExpression().isExpressionBuilder()) {
                session.log(6, "query", "FilterFactory.createValueExtractor::Does not support: " + expression + ". Query across relationship not supported", (Object[])null, null, false);
                return null;
            }
            DatabaseMapping mapping = qkExp.getContainingDescriptor().getMappingForAttributeName(expression.getName());
            if (mapping == null) {
                session.log(6, "query", "FilterFactory.createValueExtractor::Does not support: " + expression + ". Unknown mapping attribute: " + expression.getName(), (Object[])null, null, false);
                return null;
            }
            return new FilterExtractor(mapping);
        }
        if (expression.isFieldExpression()) {
            FieldExpression fieldExp = (FieldExpression)expression;
            ExpressionBuilder builder = fieldExp.getBuilder();
            ClassDescriptor desc = builder.getDescriptor();
            ObjectBuilder oBuilder = desc.getObjectBuilder();
            DatabaseMapping mapping = oBuilder.getMappingForField(fieldExp.getField());
            if (mapping == null) {
                session.log(6, "query", "FilterFactory.createValueExtractor::Does not support: " + expression + ". Unknown mapping attribute: " + fieldExp.getField(), (Object[])null, null, false);
                return null;
            }
            if (mapping.isForeignReferenceMapping()) {
                session.log(6, "query", "FilterFactory.createValueExtractor::Does not support: " + expression + ". Query across relationship not supported", (Object[])null, null, false);
                return null;
            }
            return new FilterExtractor(mapping);
        }
        session.log(6, "query", "FilterFactory.createValueExtractor::Does not support: " + expression, (Object[])null, null, false);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvocableMap.EntryAggregator createAggregator(ReportItem item, ReportQuery query, Record args, AbstractSession session) {
        boolean setSession;
        FunctionExpression expression = (FunctionExpression)item.getAttributeExpression();
        boolean bl = setSession = expression.getBuilder().getSession() == null;
        if (setSession) {
            expression.getBuilder().setSession(session);
        }
        try {
            Class resultType = expression.getResultType();
            FilterExtractor extractor = this.createValueExtractor(expression.getBaseExpression(), session);
            if (resultType == null) {
                resultType = extractor.getAttributeClass();
            }
            switch (expression.getOperator().getSelector()) {
                case 19: {
                    Count count = new Count();
                    return count;
                }
                case 20: {
                    if (BasicTypeHelperImpl.getInstance().isIntegralType((Object)resultType)) {
                        LongSum longSum = new LongSum((ValueExtractor)extractor);
                        return longSum;
                    }
                    if (BasicTypeHelperImpl.getInstance().isFloatingPointType((Object)resultType)) {
                        DoubleSum doubleSum = new DoubleSum((ValueExtractor)extractor);
                        return doubleSum;
                    }
                    if (!resultType.equals(ClassConstants.BIGDECIMAL)) break;
                    BigDecimalSum bigDecimalSum = new BigDecimalSum((ValueExtractor)extractor);
                    return bigDecimalSum;
                }
                case 21: {
                    if (BasicTypeHelperImpl.getInstance().isFloatingPointType((Object)resultType)) {
                        DoubleAverage doubleAverage = new DoubleAverage((ValueExtractor)extractor);
                        return doubleAverage;
                    }
                    if (!resultType.equals(ClassConstants.BIGDECIMAL)) break;
                    BigDecimalAverage bigDecimalAverage = new BigDecimalAverage((ValueExtractor)extractor);
                    return bigDecimalAverage;
                }
                case 23: {
                    if (BasicTypeHelperImpl.getInstance().isIntegralType((Object)resultType)) {
                        LongMin longMin = new LongMin((ValueExtractor)extractor);
                        return longMin;
                    }
                    if (BasicTypeHelperImpl.getInstance().isFloatingPointType((Object)resultType)) {
                        DoubleMin doubleMin = new DoubleMin((ValueExtractor)extractor);
                        return doubleMin;
                    }
                    if (resultType.equals(ClassConstants.BIGDECIMAL)) {
                        BigDecimalMin bigDecimalMin = new BigDecimalMin((ValueExtractor)extractor);
                        return bigDecimalMin;
                    }
                    if (!resultType.isAssignableFrom(Comparable.class)) break;
                    ComparableMin comparableMin = new ComparableMin((ValueExtractor)extractor);
                    return comparableMin;
                }
                case 22: {
                    if (BasicTypeHelperImpl.getInstance().isIntegralType((Object)resultType)) {
                        LongMax longMax = new LongMax((ValueExtractor)extractor);
                        return longMax;
                    }
                    if (BasicTypeHelperImpl.getInstance().isFloatingPointType((Object)resultType)) {
                        DoubleMax doubleMax = new DoubleMax((ValueExtractor)extractor);
                        return doubleMax;
                    }
                    if (resultType.equals(ClassConstants.BIGDECIMAL)) {
                        BigDecimalMax bigDecimalMax = new BigDecimalMax((ValueExtractor)extractor);
                        return bigDecimalMax;
                    }
                    if (!resultType.isAssignableFrom(Comparable.class)) break;
                    ComparableMax comparableMax = new ComparableMax((ValueExtractor)extractor);
                    return comparableMax;
                }
            }
            InvocableMap.EntryAggregator entryAggregator = null;
            return entryAggregator;
        }
        finally {
            if (setSession) {
                expression.getBuilder().setSession(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InvocableMap.EntryProcessor createValueExtractor(ReportItem item, ReportQuery query, Record args, AbstractSession session) {
        boolean setSession;
        Expression expression = item.getAttributeExpression();
        boolean bl = setSession = expression.getBuilder().getSession() == null;
        if (setSession) {
            expression.getBuilder().setSession(session);
        }
        try {
            if (expression.isQueryKeyExpression() || expression.isFieldExpression()) {
                ExtractorProcessor extractorProcessor = new ExtractorProcessor((ValueExtractor)this.createValueExtractor(expression, session));
                return extractorProcessor;
            }
            if (expression.isExpressionBuilder()) {
                ExtractorProcessor extractorProcessor = new ExtractorProcessor((ValueExtractor)IdentityExtractor.INSTANCE);
                return extractorProcessor;
            }
            InvocableMap.EntryProcessor entryProcessor = null;
            return entryProcessor;
        }
        finally {
            if (setSession) {
                expression.getBuilder().setSession(null);
            }
        }
    }

    public static class SubClassOf
    implements Filter,
    Serializable,
    PortableObject,
    TopLinkGridPortableObject,
    ExternalizableLite {
        protected transient Class parentClass;
        protected String parentClassName;

        public SubClassOf() {
        }

        public SubClassOf(Class parentClass) {
            this.parentClass = parentClass;
            this.parentClassName = parentClass.getName();
        }

        public boolean evaluate(Object arg0) {
            if (arg0 instanceof Wrapper) {
                arg0 = ((Wrapper)arg0).unwrap();
            }
            if (this.parentClass == null) {
                try {
                    this.parentClass = arg0.getClass().getClassLoader().loadClass(this.parentClassName);
                }
                catch (ClassNotFoundException e) {
                    throw IntegrationException.noClassFoundSubClassFilter(this.parentClassName, arg0.getClass().getClassLoader(), e);
                }
            }
            return this.parentClass.isAssignableFrom(arg0.getClass());
        }

        public void readExternal(PofReader in) throws IOException {
            this.parentClassName = in.readString(0);
        }

        public void writeExternal(PofWriter out) throws IOException {
            out.writeString(0, this.parentClassName);
        }

        public void readExternal(DataInput in) throws IOException {
            this.parentClassName = in.readLine();
        }

        public void writeExternal(DataOutput out) throws IOException {
            out.writeBytes(this.parentClassName);
            out.writeBytes("\n");
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.parentClass == null ? 0 : this.parentClass.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubClassOf other = (SubClassOf)obj;
            return !(this.parentClass == null ? other.parentClass != null : !this.parentClass.equals(other.parentClass));
        }
    }

    public static class IsNull
    extends EqualsFilter {
        public IsNull() {
        }

        public IsNull(ValueExtractor extractor) {
            super(extractor, null);
        }

        protected boolean evaluateExtracted(Object extracted) {
            return extracted == null;
        }
    }

    public static class IsNotNull
    extends EqualsFilter {
        public IsNotNull() {
        }

        public IsNotNull(ValueExtractor extractor) {
            super(extractor, null);
        }

        protected boolean evaluateExtracted(Object extracted) {
            return extracted != null;
        }
    }
}

