/*
 * Decompiled with CFR 0.152.
 */
package oracle.eclipselink.coherence.integrated.internal.querying;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import oracle.eclipselink.coherence.exceptions.IntegrationException;
import oracle.eclipselink.coherence.integrated.internal.querying.EclipseLinkQueryFailurePolicy;
import oracle.eclipselink.coherence.integrated.querying.TranslationFailureDelegate;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.sessions.Session;

public class TranslationFailureDelegateResolver {
    protected static TranslationFailureDelegate policy;

    public static TranslationFailureDelegate resolve(Session session) {
        if (policy != null) {
            return policy;
        }
        String className = (String)session.getProperty("eclipselink.coherence.query.translation-failure-delegate");
        if (className == null) {
            policy = new EclipseLinkQueryFailurePolicy();
            return policy;
        }
        try {
            Class<?> failurePolicy = session.getPlatform().getConversionManager().getLoader().loadClass(className);
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                Constructor constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(failurePolicy, new Class[0], true));
                policy = (TranslationFailureDelegate)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[0]));
            } else {
                Constructor constructor = PrivilegedAccessHelper.getDeclaredConstructorFor(failurePolicy, (Class[])new Class[0], (boolean)true);
                policy = (TranslationFailureDelegate)PrivilegedAccessHelper.invokeConstructor((Constructor)constructor, (Object[])new Object[0]);
            }
            return policy;
        }
        catch (Exception e) {
            throw IntegrationException.unableToInstantiateFailoverPolicy(className, e);
        }
    }
}

