/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.aspectj;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.aspectj.bridge.AbortException;
import com.bea.core.repackaged.aspectj.bridge.IMessage;
import com.bea.core.repackaged.aspectj.bridge.IMessageHandler;

public class AspectJWeaverMessageHandler
implements IMessageHandler {
    private static final String AJ_ID = "[AspectJ] ";
    private static final Log LOGGER = LogFactory.getLog((String)"AspectJ Weaver");

    public boolean handleMessage(IMessage message) throws AbortException {
        IMessage.Kind messageKind = message.getKind();
        if ((LOGGER.isDebugEnabled() || LOGGER.isTraceEnabled()) && messageKind == IMessage.DEBUG) {
            LOGGER.debug((Object)this.makeMessageFor(message));
            return true;
        }
        if (LOGGER.isInfoEnabled() && (messageKind == IMessage.INFO || messageKind == IMessage.WEAVEINFO)) {
            LOGGER.info((Object)this.makeMessageFor(message));
            return true;
        }
        if (LOGGER.isWarnEnabled() && messageKind == IMessage.WARNING) {
            LOGGER.warn((Object)this.makeMessageFor(message));
            return true;
        }
        if (LOGGER.isErrorEnabled() && messageKind == IMessage.ERROR) {
            LOGGER.error((Object)this.makeMessageFor(message));
            return true;
        }
        if (LOGGER.isFatalEnabled() && messageKind == IMessage.ABORT) {
            LOGGER.fatal((Object)this.makeMessageFor(message));
            return true;
        }
        return false;
    }

    private String makeMessageFor(IMessage aMessage) {
        return AJ_ID + aMessage.getMessage();
    }

    public boolean isIgnoring(IMessage.Kind messageKind) {
        return false;
    }

    public void dontIgnore(IMessage.Kind messageKind) {
    }

    public void ignore(IMessage.Kind kind) {
    }
}

