/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.aspectj.annotation;

import com.bea.core.repackaged.aopalliance.aop.Advice;
import com.bea.core.repackaged.aspectj.lang.annotation.AfterReturning;
import com.bea.core.repackaged.aspectj.lang.annotation.AfterThrowing;
import com.bea.core.repackaged.aspectj.lang.annotation.DeclareParents;
import com.bea.core.repackaged.aspectj.lang.annotation.Pointcut;
import com.bea.core.repackaged.springframework.aop.Advisor;
import com.bea.core.repackaged.springframework.aop.MethodBeforeAdvice;
import com.bea.core.repackaged.springframework.aop.aspectj.AbstractAspectJAdvice;
import com.bea.core.repackaged.springframework.aop.aspectj.AspectJAfterAdvice;
import com.bea.core.repackaged.springframework.aop.aspectj.AspectJAfterReturningAdvice;
import com.bea.core.repackaged.springframework.aop.aspectj.AspectJAfterThrowingAdvice;
import com.bea.core.repackaged.springframework.aop.aspectj.AspectJAroundAdvice;
import com.bea.core.repackaged.springframework.aop.aspectj.AspectJExpressionPointcut;
import com.bea.core.repackaged.springframework.aop.aspectj.AspectJMethodBeforeAdvice;
import com.bea.core.repackaged.springframework.aop.aspectj.DeclareParentsAdvisor;
import com.bea.core.repackaged.springframework.aop.aspectj.annotation.AbstractAspectJAdvisorFactory;
import com.bea.core.repackaged.springframework.aop.aspectj.annotation.InstantiationModelAwarePointcutAdvisorImpl;
import com.bea.core.repackaged.springframework.aop.aspectj.annotation.LazySingletonAspectInstanceFactoryDecorator;
import com.bea.core.repackaged.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import com.bea.core.repackaged.springframework.aop.framework.AopConfigException;
import com.bea.core.repackaged.springframework.aop.support.DefaultPointcutAdvisor;
import com.bea.core.repackaged.springframework.core.annotation.AnnotationUtils;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectiveAspectJAdvisorFactory
extends AbstractAspectJAdvisorFactory {
    @Override
    public List<Advisor> getAdvisors(MetadataAwareAspectInstanceFactory maaif) {
        Class aspectClass = maaif.getAspectMetadata().getAspectClass();
        final String aspectName = maaif.getAspectMetadata().getAspectName();
        this.validate(aspectClass);
        final LazySingletonAspectInstanceFactoryDecorator lazySingletonAspectInstanceFactory = new LazySingletonAspectInstanceFactoryDecorator(maaif);
        final LinkedList<Advisor> advisors = new LinkedList<Advisor>();
        ReflectionUtils.doWithMethods(aspectClass, new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException {
                Advisor advisor;
                if (AnnotationUtils.getAnnotation(method, Pointcut.class) == null && (advisor = ReflectiveAspectJAdvisorFactory.this.getAdvisor(method, lazySingletonAspectInstanceFactory, advisors.size(), aspectName)) != null) {
                    advisors.add(advisor);
                }
            }
        });
        if (!advisors.isEmpty() && lazySingletonAspectInstanceFactory.getAspectMetadata().isLazilyInstantiated()) {
            SyntheticInstantiationAdvisor instantiationAdvisor = new SyntheticInstantiationAdvisor(lazySingletonAspectInstanceFactory);
            advisors.add(0, instantiationAdvisor);
        }
        for (Field field : aspectClass.getDeclaredFields()) {
            Advisor advisor = this.getDeclareParentsAdvisor(field);
            if (advisor == null) continue;
            advisors.add(advisor);
        }
        return advisors;
    }

    private Advisor getDeclareParentsAdvisor(Field introductionField) {
        DeclareParents declareParents = introductionField.getAnnotation(DeclareParents.class);
        if (declareParents == null) {
            return null;
        }
        if (DeclareParents.class.equals((Object)declareParents.defaultImpl())) {
            throw new IllegalStateException("defaultImpl must be set on DeclareParents");
        }
        return new DeclareParentsAdvisor(introductionField.getType(), declareParents.value(), declareParents.defaultImpl());
    }

    @Override
    public Advisor getAdvisor(Method candidateAdviceMethod, MetadataAwareAspectInstanceFactory aif, int declarationOrderInAspect, String aspectName) {
        this.validate(aif.getAspectMetadata().getAspectClass());
        AspectJExpressionPointcut ajexp = this.getPointcut(candidateAdviceMethod, aif.getAspectMetadata().getAspectClass());
        if (ajexp == null) {
            return null;
        }
        return new InstantiationModelAwarePointcutAdvisorImpl(this, ajexp, aif, candidateAdviceMethod, declarationOrderInAspect, aspectName);
    }

    private AspectJExpressionPointcut getPointcut(Method candidateAdviceMethod, Class<?> candidateAspectClass) {
        AbstractAspectJAdvisorFactory.AspectJAnnotation aspectJAnnotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(candidateAdviceMethod);
        if (aspectJAnnotation == null) {
            return null;
        }
        AspectJExpressionPointcut ajexp = new AspectJExpressionPointcut(candidateAspectClass, new String[0], new Class[0]);
        ajexp.setExpression(aspectJAnnotation.getPointcutExpression());
        return ajexp;
    }

    @Override
    public Advice getAdvice(Method candidateAdviceMethod, AspectJExpressionPointcut ajexp, MetadataAwareAspectInstanceFactory aif, int declarationOrderInAspect, String aspectName) {
        AbstractAspectJAdvice springAdvice;
        Class candidateAspectClass = aif.getAspectMetadata().getAspectClass();
        this.validate(candidateAspectClass);
        AbstractAspectJAdvisorFactory.AspectJAnnotation aspectJAnnotation = AbstractAspectJAdvisorFactory.findAspectJAnnotationOnMethod(candidateAdviceMethod);
        if (aspectJAnnotation == null) {
            return null;
        }
        if (!this.isAspect(candidateAspectClass)) {
            throw new AopConfigException("Advice must be declared inside an aspect type: Offending method '" + candidateAdviceMethod + "' in class [" + candidateAspectClass.getName() + "]");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Found AspectJ method: " + candidateAdviceMethod));
        }
        switch (aspectJAnnotation.getAnnotationType()) {
            case AtBefore: {
                springAdvice = new AspectJMethodBeforeAdvice(candidateAdviceMethod, ajexp, aif);
                break;
            }
            case AtAfter: {
                springAdvice = new AspectJAfterAdvice(candidateAdviceMethod, ajexp, aif);
                break;
            }
            case AtAfterReturning: {
                springAdvice = new AspectJAfterReturningAdvice(candidateAdviceMethod, ajexp, aif);
                AfterReturning afterReturningAnnotation = (AfterReturning)aspectJAnnotation.getAnnotation();
                if (!StringUtils.hasText(afterReturningAnnotation.returning())) break;
                springAdvice.setReturningName(afterReturningAnnotation.returning());
                break;
            }
            case AtAfterThrowing: {
                springAdvice = new AspectJAfterThrowingAdvice(candidateAdviceMethod, ajexp, aif);
                AfterThrowing afterThrowingAnnotation = (AfterThrowing)aspectJAnnotation.getAnnotation();
                if (!StringUtils.hasText(afterThrowingAnnotation.throwing())) break;
                springAdvice.setThrowingName(afterThrowingAnnotation.throwing());
                break;
            }
            case AtAround: {
                springAdvice = new AspectJAroundAdvice(candidateAdviceMethod, ajexp, aif);
                break;
            }
            case AtPointcut: {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Processing pointcut '" + candidateAdviceMethod.getName() + "'"));
                }
                return null;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported advice type on method " + candidateAdviceMethod);
            }
        }
        springAdvice.setAspectName(aspectName);
        springAdvice.setDeclarationOrder(declarationOrderInAspect);
        String[] argNames = this.parameterNameDiscoverer.getParameterNames(candidateAdviceMethod);
        if (argNames != null) {
            springAdvice.setArgumentNamesFromStringArray(argNames);
        }
        springAdvice.calculateArgumentBindings();
        return springAdvice;
    }

    protected static class SyntheticInstantiationAdvisor
    extends DefaultPointcutAdvisor {
        public SyntheticInstantiationAdvisor(final MetadataAwareAspectInstanceFactory aif) {
            super(aif.getAspectMetadata().getPerClausePointcut(), new MethodBeforeAdvice(){

                public void before(Method method, Object[] args, Object target) {
                    aif.getAspectInstance();
                }
            });
        }
    }
}

