/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.config;

import com.bea.core.repackaged.springframework.aop.aspectj.autoproxy.AspectJAwareAdvisorAutoProxyCreator;
import com.bea.core.repackaged.springframework.aop.framework.autoproxy.InfrastructureAdvisorAutoProxyCreator;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bea.core.repackaged.springframework.beans.factory.support.RootBeanDefinition;
import com.bea.core.repackaged.springframework.core.JdkVersion;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import java.util.ArrayList;
import java.util.List;

public abstract class AopConfigUtils {
    public static final String AUTO_PROXY_CREATOR_BEAN_NAME = "com.bea.core.repackaged.springframework.aop.config.internalAutoProxyCreator";
    private static final String ASPECTJ_ANNOTATION_AUTO_PROXY_CREATOR_CLASS_NAME = "com.bea.core.repackaged.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator";
    private static final List APC_PRIORITY_LIST = new ArrayList();

    public static BeanDefinition registerAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        return AopConfigUtils.registerAutoProxyCreatorIfNecessary(registry, null);
    }

    public static BeanDefinition registerAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, Object source) {
        return AopConfigUtils.registerOrEscalateApcAsRequired(InfrastructureAdvisorAutoProxyCreator.class, registry, source);
    }

    public static BeanDefinition registerAspectJAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        return AopConfigUtils.registerAspectJAutoProxyCreatorIfNecessary(registry, null);
    }

    public static BeanDefinition registerAspectJAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, Object source) {
        return AopConfigUtils.registerOrEscalateApcAsRequired(AspectJAwareAdvisorAutoProxyCreator.class, registry, source);
    }

    public static BeanDefinition registerAspectJAnnotationAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry) {
        return AopConfigUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary(registry, null);
    }

    public static BeanDefinition registerAspectJAnnotationAutoProxyCreatorIfNecessary(BeanDefinitionRegistry registry, Object source) {
        Class cls = AopConfigUtils.getAspectJAnnotationAutoProxyCreatorClassIfPossible();
        return AopConfigUtils.registerOrEscalateApcAsRequired(cls, registry, source);
    }

    public static void forceAutoProxyCreatorToUseClassProxying(BeanDefinitionRegistry registry) {
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            BeanDefinition definition = registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            definition.getPropertyValues().addPropertyValue("proxyTargetClass", Boolean.TRUE);
        }
    }

    private static BeanDefinition registerOrEscalateApcAsRequired(Class cls, BeanDefinitionRegistry registry, Object source) {
        Assert.notNull(registry, "BeanDefinitionRegistry must not be null");
        if (registry.containsBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME)) {
            int requiredPriority;
            int currentPriority;
            BeanDefinition apcDefinition = registry.getBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME);
            if (!cls.getName().equals(apcDefinition.getBeanClassName()) && (currentPriority = AopConfigUtils.findPriorityForClass(apcDefinition.getBeanClassName())) < (requiredPriority = AopConfigUtils.findPriorityForClass(cls.getName()))) {
                apcDefinition.setBeanClassName(cls.getName());
            }
            return null;
        }
        RootBeanDefinition beanDefinition = new RootBeanDefinition(cls);
        beanDefinition.setSource(source);
        beanDefinition.getPropertyValues().addPropertyValue("order", new Integer(Integer.MIN_VALUE));
        beanDefinition.setRole(2);
        registry.registerBeanDefinition(AUTO_PROXY_CREATOR_BEAN_NAME, beanDefinition);
        return beanDefinition;
    }

    private static Class getAspectJAnnotationAutoProxyCreatorClassIfPossible() {
        if (JdkVersion.getMajorJavaVersion() < 2) {
            throw new IllegalStateException("AnnotationAwareAspectJAutoProxyCreator is only available on Java 1.5 and higher");
        }
        try {
            return ClassUtils.forName(ASPECTJ_ANNOTATION_AUTO_PROXY_CREATOR_CLASS_NAME, AopConfigUtils.class.getClassLoader());
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Unable to load Java 1.5 dependent class [org.springframework.aop.aspectj.annotation.AnnotationAwareAspectJAutoProxyCreator]", ex);
        }
    }

    private static int findPriorityForClass(String className) {
        Assert.notNull(className, "Class name must not be null");
        for (int i = 0; i < APC_PRIORITY_LIST.size(); ++i) {
            String str = (String)APC_PRIORITY_LIST.get(i);
            if (!className.equals(str)) continue;
            return i;
        }
        throw new IllegalArgumentException("Class name [" + className + "] is not a known auto-proxy creator class");
    }

    static {
        APC_PRIORITY_LIST.add(InfrastructureAdvisorAutoProxyCreator.class.getName());
        APC_PRIORITY_LIST.add(AspectJAwareAdvisorAutoProxyCreator.class.getName());
        APC_PRIORITY_LIST.add(ASPECTJ_ANNOTATION_AUTO_PROXY_CREATOR_CLASS_NAME);
    }
}

