/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.framework;

import com.bea.core.repackaged.aopalliance.aop.Advice;
import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.aop.Advisor;
import com.bea.core.repackaged.springframework.aop.PointcutAdvisor;
import com.bea.core.repackaged.springframework.aop.RawTargetAccess;
import com.bea.core.repackaged.springframework.aop.TargetSource;
import com.bea.core.repackaged.springframework.aop.framework.AdvisedSupport;
import com.bea.core.repackaged.springframework.aop.framework.AopConfigException;
import com.bea.core.repackaged.springframework.aop.framework.AopContext;
import com.bea.core.repackaged.springframework.aop.framework.AopProxy;
import com.bea.core.repackaged.springframework.aop.framework.AopProxyUtils;
import com.bea.core.repackaged.springframework.aop.framework.ReflectiveMethodInvocation;
import com.bea.core.repackaged.springframework.aop.support.AopUtils;
import com.bea.core.repackaged.springframework.core.SmartClassLoader;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.sf.cglib.core.CodeGenerationException;
import net.sf.cglib.core.GeneratorStrategy;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Dispatcher;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import net.sf.cglib.transform.impl.UndeclaredThrowableStrategy;

final class Cglib2AopProxy
implements AopProxy,
Serializable {
    private static final int AOP_PROXY = 0;
    private static final int INVOKE_TARGET = 1;
    private static final int NO_OVERRIDE = 2;
    private static final int DISPATCH_TARGET = 3;
    private static final int DISPATCH_ADVISED = 4;
    private static final int INVOKE_EQUALS = 5;
    private static final int INVOKE_HASHCODE = 6;
    protected static final Log logger = LogFactory.getLog((Class)Cglib2AopProxy.class);
    private static final Map validatedClasses = new WeakHashMap();
    protected final AdvisedSupport advised;
    private Object[] constructorArgs;
    private Class[] constructorArgTypes;
    private final transient AdvisedDispatcher advisedDispatcher;
    private transient Map fixedInterceptorMap;
    private transient int fixedInterceptorOffset;
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$org$springframework$aop$framework$Advised;

    public Cglib2AopProxy(AdvisedSupport config) throws AopConfigException {
        Assert.notNull(config, "AdvisedSupport must not be null");
        if (config.getAdvisors().length == 0 && config.getTargetSource() == AdvisedSupport.EMPTY_TARGET_SOURCE) {
            throw new AopConfigException("No advisors and no TargetSource specified");
        }
        this.advised = config;
        this.advisedDispatcher = new AdvisedDispatcher(this.advised);
    }

    public void setConstructorArguments(Object[] constructorArgs, Class[] constructorArgTypes) {
        if (constructorArgs == null || constructorArgTypes == null) {
            throw new IllegalArgumentException("Both 'constructorArgs' and 'constructorArgTypes' need to be specified");
        }
        if (constructorArgs.length != constructorArgTypes.length) {
            throw new IllegalArgumentException("Number of 'constructorArgs' (" + constructorArgs.length + ") must match number of 'constructorArgTypes' (" + constructorArgTypes.length + ")");
        }
        this.constructorArgs = constructorArgs;
        this.constructorArgTypes = constructorArgTypes;
    }

    public Object getProxy() {
        return this.getProxy(null);
    }

    public Object getProxy(ClassLoader classLoader) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating CGLIB2 proxy: target source is " + this.advised.getTargetSource()));
        }
        try {
            Class rootClass = this.advised.getTargetClass();
            Assert.state(rootClass != null, "Target class must be available for creating a CGLIB proxy");
            Class proxySuperClass = rootClass;
            if (AopUtils.isCglibProxyClass(rootClass)) {
                proxySuperClass = rootClass.getSuperclass();
                Class<?>[] additionalInterfaces = rootClass.getInterfaces();
                for (int i = 0; i < additionalInterfaces.length; ++i) {
                    Class<?> additionalInterface = additionalInterfaces[i];
                    this.advised.addInterface(additionalInterface);
                }
            }
            this.validateClassIfNecessary(proxySuperClass);
            Enhancer enhancer = this.createEnhancer();
            if (classLoader != null) {
                enhancer.setClassLoader(classLoader);
                if (classLoader instanceof SmartClassLoader && ((SmartClassLoader)((Object)classLoader)).isClassReloadable(proxySuperClass)) {
                    enhancer.setUseCache(false);
                }
            }
            enhancer.setSuperclass(proxySuperClass);
            enhancer.setStrategy((GeneratorStrategy)new UndeclaredThrowableStrategy(UndeclaredThrowableException.class));
            enhancer.setInterfaces(AopProxyUtils.completeProxiedInterfaces(this.advised));
            enhancer.setInterceptDuringConstruction(false);
            Callback[] callbacks = this.getCallbacks(rootClass);
            enhancer.setCallbacks(callbacks);
            enhancer.setCallbackFilter((CallbackFilter)new ProxyCallbackFilter(this.advised.getConfigurationOnlyCopy(), this.fixedInterceptorMap, this.fixedInterceptorOffset));
            Class[] types = new Class[callbacks.length];
            for (int x = 0; x < types.length; ++x) {
                types[x] = callbacks[x].getClass();
            }
            enhancer.setCallbackTypes(types);
            Object proxy = this.constructorArgs != null ? enhancer.create(this.constructorArgTypes, this.constructorArgs) : enhancer.create();
            return proxy;
        }
        catch (CodeGenerationException ex) {
            throw new AopConfigException("Could not generate CGLIB subclass of class [" + this.advised.getTargetClass() + "]: " + "Common causes of this problem include using a final class or a non-visible class", ex);
        }
        catch (IllegalArgumentException ex) {
            throw new AopConfigException("Could not generate CGLIB subclass of class [" + this.advised.getTargetClass() + "]: " + "Common causes of this problem include using a final class or a non-visible class", ex);
        }
        catch (Exception ex) {
            throw new AopConfigException("Unexpected AOP exception", ex);
        }
    }

    protected Enhancer createEnhancer() {
        return new Enhancer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateClassIfNecessary(Class proxySuperClass) {
        if (logger.isWarnEnabled()) {
            Map map = validatedClasses;
            synchronized (map) {
                if (!validatedClasses.containsKey(proxySuperClass)) {
                    this.doValidateClass(proxySuperClass);
                    validatedClasses.put(proxySuperClass, Boolean.TRUE);
                }
            }
        }
    }

    private void doValidateClass(Class proxySuperClass) {
        Method[] methods = proxySuperClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method;
            if ((class$java$lang$Object == null ? Cglib2AopProxy.class$("java.lang.Object") : class$java$lang$Object).equals((method = methods[i]).getDeclaringClass()) || !Modifier.isFinal(method.getModifiers())) continue;
            logger.warn((Object)("Unable to proxy method [" + method + "] because it is final: " + "All calls to this method via a proxy will be routed directly to the proxy."));
        }
    }

    private Callback[] getCallbacks(Class rootClass) throws Exception {
        Callback[] callbacks;
        boolean exposeProxy = this.advised.isExposeProxy();
        boolean isFrozen = this.advised.isFrozen();
        boolean isStatic = this.advised.getTargetSource().isStatic();
        DynamicAdvisedInterceptor aopInterceptor = new DynamicAdvisedInterceptor(this.advised);
        MethodInterceptor targetInterceptor = null;
        targetInterceptor = exposeProxy ? (isStatic ? new StaticUnadvisedExposedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedExposedInterceptor(this.advised.getTargetSource())) : (isStatic ? new StaticUnadvisedInterceptor(this.advised.getTargetSource().getTarget()) : new DynamicUnadvisedInterceptor(this.advised.getTargetSource()));
        Serializable targetDispatcher = isStatic ? new StaticDispatcher(this.advised.getTargetSource().getTarget()) : new SerializableNoOp();
        Callback[] mainCallbacks = new Callback[]{aopInterceptor, targetInterceptor, new SerializableNoOp(), targetDispatcher, this.advisedDispatcher, new EqualsInterceptor(this.advised), new HashCodeInterceptor(this.advised)};
        if (isStatic && isFrozen) {
            int x;
            Method[] methods = rootClass.getMethods();
            Callback[] fixedCallbacks = new Callback[methods.length];
            this.fixedInterceptorMap = new HashMap(methods.length);
            for (x = 0; x < methods.length; ++x) {
                List chain = this.advised.getInterceptorsAndDynamicInterceptionAdvice(methods[x], rootClass);
                fixedCallbacks[x] = new FixedChainStaticTargetInterceptor(chain, this.advised.getTargetSource().getTarget(), this.advised.getTargetClass());
                this.fixedInterceptorMap.put(methods[x].toString(), new Integer(x));
            }
            callbacks = new Callback[mainCallbacks.length + fixedCallbacks.length];
            for (x = 0; x < mainCallbacks.length; ++x) {
                callbacks[x] = mainCallbacks[x];
            }
            for (x = 0; x < fixedCallbacks.length; ++x) {
                callbacks[x + mainCallbacks.length] = fixedCallbacks[x];
            }
            this.fixedInterceptorOffset = mainCallbacks.length;
        } else {
            callbacks = mainCallbacks;
        }
        return callbacks;
    }

    private static Object massageReturnTypeIfNecessary(Object proxy, Object target, Method method, Object retVal) {
        if (retVal != null && retVal == target && !RawTargetAccess.class.isAssignableFrom(method.getDeclaringClass())) {
            retVal = proxy;
        }
        return retVal;
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Cglib2AopProxy && AopProxyUtils.equalsInProxy(this.advised, ((Cglib2AopProxy)other).advised);
    }

    public int hashCode() {
        return Cglib2AopProxy.class.hashCode() * 13 + this.advised.getTargetSource().hashCode();
    }

    private static class ProxyCallbackFilter
    implements CallbackFilter {
        private final AdvisedSupport advised;
        private final Map fixedInterceptorMap;
        private final int fixedInterceptorOffset;

        public ProxyCallbackFilter(AdvisedSupport advised, Map fixedInterceptorMap, int fixedInterceptorOffset) {
            this.advised = advised;
            this.fixedInterceptorMap = fixedInterceptorMap;
            this.fixedInterceptorOffset = fixedInterceptorOffset;
        }

        public int accept(Method method) {
            if (AopUtils.isFinalizeMethod(method)) {
                logger.debug((Object)"Found finalize() method - using NO_OVERRIDE");
                return 2;
            }
            if (!this.advised.isOpaque() && method.getDeclaringClass().isInterface() && method.getDeclaringClass().isAssignableFrom(class$org$springframework$aop$framework$Advised == null ? (class$org$springframework$aop$framework$Advised = Cglib2AopProxy.class$("com.bea.core.repackaged.springframework.aop.framework.Advised")) : class$org$springframework$aop$framework$Advised)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method is declared on Advised interface: " + method));
                }
                return 4;
            }
            if (AopUtils.isEqualsMethod(method)) {
                logger.debug((Object)("Found 'equals' method: " + method));
                return 5;
            }
            if (AopUtils.isHashCodeMethod(method)) {
                logger.debug((Object)("Found 'hashCode' method: " + method));
                return 6;
            }
            Class targetClass = this.advised.getTargetClass();
            List chain = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass);
            boolean haveAdvice = !chain.isEmpty();
            boolean exposeProxy = this.advised.isExposeProxy();
            boolean isStatic = this.advised.getTargetSource().isStatic();
            boolean isFrozen = this.advised.isFrozen();
            if (haveAdvice || !isFrozen) {
                if (exposeProxy) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Must expose proxy on advised method: " + method));
                    }
                    return 0;
                }
                String key = method.toString();
                if (isStatic && isFrozen && this.fixedInterceptorMap.containsKey(key)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Method has advice and optimisations are enabled: " + method));
                    }
                    int index = (Integer)this.fixedInterceptorMap.get(key);
                    return index + this.fixedInterceptorOffset;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Unable to apply any optimisations to advised method: " + method));
                }
                return 0;
            }
            if (exposeProxy || !isStatic) {
                return 1;
            }
            Class<?> returnType = method.getReturnType();
            if (targetClass == returnType) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method " + method + "has return type same as target type (may return this) - using INVOKE_TARGET"));
                }
                return 1;
            }
            if (returnType.isPrimitive() || !returnType.isAssignableFrom(targetClass)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method " + method + " has return type that ensures this cannot be returned- using DISPATCH_TARGET"));
                }
                return 3;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Method " + method + "has return type that is assignable from the target type (may return this) - " + "using INVOKE_TARGET"));
            }
            return 1;
        }

        public boolean equals(Object other) {
            Advisor[] thatAdvisors;
            if (other == this) {
                return true;
            }
            if (!(other instanceof ProxyCallbackFilter)) {
                return false;
            }
            ProxyCallbackFilter otherCallbackFilter = (ProxyCallbackFilter)other;
            AdvisedSupport otherAdvised = otherCallbackFilter.advised;
            if (this.advised == null || otherAdvised == null) {
                return false;
            }
            if (this.advised.isFrozen() != otherAdvised.isFrozen()) {
                return false;
            }
            if (this.advised.isExposeProxy() != otherAdvised.isExposeProxy()) {
                return false;
            }
            if (this.advised.getTargetSource().isStatic() != otherAdvised.getTargetSource().isStatic()) {
                return false;
            }
            if (!AopProxyUtils.equalsProxiedInterfaces(this.advised, otherAdvised)) {
                return false;
            }
            Advisor[] thisAdvisors = this.advised.getAdvisors();
            if (thisAdvisors.length != (thatAdvisors = otherAdvised.getAdvisors()).length) {
                return false;
            }
            for (int i = 0; i < thisAdvisors.length; ++i) {
                Advisor thisAdvisor = thisAdvisors[i];
                Advisor thatAdvisor = thatAdvisors[i];
                if (!this.equalsAdviceClasses(thisAdvisor, thatAdvisor)) {
                    return false;
                }
                if (this.equalsPointcuts(thisAdvisor, thatAdvisor)) continue;
                return false;
            }
            return true;
        }

        private boolean equalsAdviceClasses(Advisor a, Advisor b) {
            Advice aa = a.getAdvice();
            Advice ba = b.getAdvice();
            if (aa == null || ba == null) {
                return aa == ba;
            }
            return aa.getClass().equals(ba.getClass());
        }

        private boolean equalsPointcuts(Advisor a, Advisor b) {
            if (a instanceof PointcutAdvisor ^ b instanceof PointcutAdvisor) {
                return false;
            }
            if (a instanceof PointcutAdvisor && b instanceof PointcutAdvisor) {
                return ObjectUtils.nullSafeEquals(((PointcutAdvisor)a).getPointcut(), ((PointcutAdvisor)b).getPointcut());
            }
            return true;
        }

        public int hashCode() {
            int hashCode = 0;
            Advisor[] advisors = this.advised.getAdvisors();
            for (int i = 0; i < advisors.length; ++i) {
                Advice advice = advisors[i].getAdvice();
                if (advice == null) continue;
                hashCode = 13 * hashCode + advice.getClass().hashCode();
            }
            hashCode = 13 * hashCode + (this.advised.isFrozen() ? 1 : 0);
            hashCode = 13 * hashCode + (this.advised.isExposeProxy() ? 1 : 0);
            hashCode = 13 * hashCode + (this.advised.isOptimize() ? 1 : 0);
            hashCode = 13 * hashCode + (this.advised.isOpaque() ? 1 : 0);
            return hashCode;
        }
    }

    private static class CglibMethodInvocation
    extends ReflectiveMethodInvocation {
        private final MethodProxy methodProxy;
        private boolean protectedMethod;

        public CglibMethodInvocation(Object proxy, Object target, Method method, Object[] arguments, Class targetClass, List interceptorsAndDynamicMethodMatchers, MethodProxy methodProxy) {
            super(proxy, target, method, arguments, targetClass, interceptorsAndDynamicMethodMatchers);
            this.methodProxy = methodProxy;
            this.protectedMethod = Modifier.isProtected(method.getModifiers());
        }

        protected Object invokeJoinpoint() throws Throwable {
            if (this.protectedMethod) {
                return super.invokeJoinpoint();
            }
            return this.methodProxy.invoke(this.target, this.arguments);
        }
    }

    private static class DynamicAdvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private AdvisedSupport advised;

        public DynamicAdvisedInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            boolean setProxyContext;
            Object oldProxy;
            block8: {
                CglibMethodInvocation invocation = null;
                oldProxy = null;
                setProxyContext = false;
                Class<?> targetClass = null;
                Object target = null;
                try {
                    List chain;
                    Object retVal = null;
                    if (this.advised.exposeProxy) {
                        oldProxy = AopContext.setCurrentProxy(proxy);
                        setProxyContext = true;
                    }
                    if ((target = this.getTarget()) != null) {
                        targetClass = target.getClass();
                    }
                    if ((chain = this.advised.getInterceptorsAndDynamicInterceptionAdvice(method, targetClass)).isEmpty() && Modifier.isPublic(method.getModifiers())) {
                        retVal = methodProxy.invoke(target, args);
                    } else {
                        invocation = new CglibMethodInvocation(proxy, target, method, args, targetClass, chain, methodProxy);
                        retVal = invocation.proceed();
                    }
                    object = retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, method, retVal);
                    Object var14_13 = null;
                    if (target == null) break block8;
                }
                catch (Throwable throwable) {
                    block9: {
                        Object var14_14 = null;
                        if (target != null) {
                            this.releaseTarget(target);
                        }
                        if (!setProxyContext) break block9;
                        AopContext.setCurrentProxy(oldProxy);
                    }
                    throw throwable;
                }
                this.releaseTarget(target);
            }
            if (setProxyContext) {
                AopContext.setCurrentProxy(oldProxy);
            }
            return object;
        }

        public boolean equals(Object other) {
            return this == other || other instanceof DynamicAdvisedInterceptor && this.advised.equals(((DynamicAdvisedInterceptor)other).advised);
        }

        public int hashCode() {
            return this.advised.hashCode();
        }

        protected Object getTarget() throws Exception {
            return this.advised.getTargetSource().getTarget();
        }

        protected void releaseTarget(Object target) throws Exception {
            this.advised.getTargetSource().releaseTarget(target);
        }
    }

    private static class FixedChainStaticTargetInterceptor
    implements MethodInterceptor,
    Serializable {
        private final List adviceChain;
        private final Object target;
        private final Class targetClass;

        public FixedChainStaticTargetInterceptor(List adviceChain, Object target, Class targetClass) {
            this.adviceChain = adviceChain;
            this.target = target;
            this.targetClass = targetClass;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = null;
            CglibMethodInvocation invocation = new CglibMethodInvocation(proxy, this.target, method, args, this.targetClass, this.adviceChain, methodProxy);
            retVal = invocation.proceed();
            retVal = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, method, retVal);
            return retVal;
        }
    }

    private static class HashCodeInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public HashCodeInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            return new Integer((class$org$springframework$aop$framework$Cglib2AopProxy == null ? (class$org$springframework$aop$framework$Cglib2AopProxy = Cglib2AopProxy.class$("com.bea.core.repackaged.springframework.aop.framework.Cglib2AopProxy")) : class$org$springframework$aop$framework$Cglib2AopProxy).hashCode() * 13 + this.advised.getTargetSource().hashCode());
        }
    }

    private static class EqualsInterceptor
    implements MethodInterceptor,
    Serializable {
        private final AdvisedSupport advised;

        public EqualsInterceptor(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) {
            Callback callback;
            Object other = args[0];
            if (proxy == other) {
                return Boolean.TRUE;
            }
            AdvisedSupport otherAdvised = null;
            if (other instanceof Factory) {
                callback = ((Factory)other).getCallback(5);
                if (!(callback instanceof EqualsInterceptor)) {
                    return Boolean.FALSE;
                }
            } else {
                return Boolean.FALSE;
            }
            otherAdvised = ((EqualsInterceptor)callback).advised;
            return AopProxyUtils.equalsInProxy(this.advised, otherAdvised) ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    private static class AdvisedDispatcher
    implements Dispatcher,
    Serializable {
        private final AdvisedSupport advised;

        public AdvisedDispatcher(AdvisedSupport advised) {
            this.advised = advised;
        }

        public Object loadObject() throws Exception {
            return this.advised;
        }
    }

    private static class StaticDispatcher
    implements Dispatcher,
    Serializable {
        private Object target;

        public StaticDispatcher(Object target) {
            this.target = target;
        }

        public Object loadObject() {
            return this.target;
        }
    }

    private static class DynamicUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final TargetSource targetSource;

        public DynamicUnadvisedExposedInterceptor(TargetSource targetSource) {
            this.targetSource = targetSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            Object oldProxy = null;
            Object target = this.targetSource.getTarget();
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = methodProxy.invoke(target, args);
                object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, method, retVal);
                Object var10_9 = null;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                AopContext.setCurrentProxy(oldProxy);
                this.targetSource.releaseTarget(target);
                throw throwable;
            }
            AopContext.setCurrentProxy(oldProxy);
            this.targetSource.releaseTarget(target);
            return object;
        }
    }

    private static class DynamicUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final TargetSource targetSource;

        public DynamicUnadvisedInterceptor(TargetSource targetSource) {
            this.targetSource = targetSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            Object target = this.targetSource.getTarget();
            try {
                Object retVal = methodProxy.invoke(target, args);
                object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, target, method, retVal);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.targetSource.releaseTarget(target);
                throw throwable;
            }
            this.targetSource.releaseTarget(target);
            return object;
        }
    }

    private static class StaticUnadvisedExposedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedExposedInterceptor(Object target) {
            this.target = target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object object;
            Object oldProxy = null;
            try {
                oldProxy = AopContext.setCurrentProxy(proxy);
                Object retVal = methodProxy.invoke(this.target, args);
                object = Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, method, retVal);
                Object var9_8 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                AopContext.setCurrentProxy(oldProxy);
                throw throwable;
            }
            AopContext.setCurrentProxy(oldProxy);
            return object;
        }
    }

    private static class StaticUnadvisedInterceptor
    implements MethodInterceptor,
    Serializable {
        private final Object target;

        public StaticUnadvisedInterceptor(Object target) {
            this.target = target;
        }

        public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
            Object retVal = methodProxy.invoke(this.target, args);
            return Cglib2AopProxy.massageReturnTypeIfNecessary(proxy, this.target, method, retVal);
        }
    }

    public static class SerializableNoOp
    implements NoOp,
    Serializable {
    }
}

