/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.framework;

import com.bea.core.repackaged.aopalliance.intercept.Interceptor;
import com.bea.core.repackaged.springframework.aop.TargetSource;
import com.bea.core.repackaged.springframework.aop.framework.AopProxy;
import com.bea.core.repackaged.springframework.aop.framework.ProxyCreatorSupport;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ClassUtils;

public class ProxyFactory
extends ProxyCreatorSupport
implements AopProxy {
    public ProxyFactory() {
    }

    public ProxyFactory(Object target) {
        Assert.notNull(target, "Target object must not be null");
        this.setInterfaces(ClassUtils.getAllInterfaces(target));
        this.setTarget(target);
    }

    public ProxyFactory(Class[] proxyInterfaces) {
        this.setInterfaces(proxyInterfaces);
    }

    public ProxyFactory(Class proxyInterface, Interceptor interceptor) {
        this.addInterface(proxyInterface);
        this.addAdvice(interceptor);
    }

    public ProxyFactory(Class proxyInterface, TargetSource targetSource) {
        this.addInterface(proxyInterface);
        this.setTargetSource(targetSource);
    }

    public Object getProxy() {
        return this.createAopProxy().getProxy();
    }

    public Object getProxy(ClassLoader classLoader) {
        return this.createAopProxy().getProxy(classLoader);
    }

    public static Object getProxy(Class proxyInterface, Interceptor interceptor) {
        return new ProxyFactory(proxyInterface, interceptor).getProxy();
    }

    public static Object getProxy(Class proxyInterface, TargetSource targetSource) {
        return new ProxyFactory(proxyInterface, targetSource).getProxy();
    }

    public static Object getProxy(TargetSource targetSource) {
        if (targetSource.getTargetClass() == null) {
            throw new IllegalArgumentException("Cannot create class proxy for TargetSource with null target class");
        }
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.setTargetSource(targetSource);
        proxyFactory.setProxyTargetClass(true);
        return proxyFactory.getProxy();
    }
}

