/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.framework;

import com.bea.core.repackaged.aopalliance.aop.Advice;
import com.bea.core.repackaged.aopalliance.intercept.Interceptor;
import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.aop.Advisor;
import com.bea.core.repackaged.springframework.aop.TargetSource;
import com.bea.core.repackaged.springframework.aop.framework.AopConfigException;
import com.bea.core.repackaged.springframework.aop.framework.AopProxy;
import com.bea.core.repackaged.springframework.aop.framework.ProxyCreatorSupport;
import com.bea.core.repackaged.springframework.aop.framework.adapter.AdvisorAdapterRegistry;
import com.bea.core.repackaged.springframework.aop.framework.adapter.GlobalAdvisorAdapterRegistry;
import com.bea.core.repackaged.springframework.aop.framework.adapter.UnknownAdviceTypeException;
import com.bea.core.repackaged.springframework.aop.target.SingletonTargetSource;
import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.factory.BeanClassLoaderAware;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryAware;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryUtils;
import com.bea.core.repackaged.springframework.beans.factory.FactoryBean;
import com.bea.core.repackaged.springframework.beans.factory.FactoryBeanNotInitializedException;
import com.bea.core.repackaged.springframework.beans.factory.ListableBeanFactory;
import com.bea.core.repackaged.springframework.core.OrderComparator;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ProxyFactoryBean
extends ProxyCreatorSupport
implements FactoryBean,
BeanClassLoaderAware,
BeanFactoryAware {
    public static final String GLOBAL_SUFFIX = "*";
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String[] interceptorNames;
    private String targetName;
    private boolean autodetectInterfaces = true;
    private boolean singleton = true;
    private AdvisorAdapterRegistry advisorAdapterRegistry = GlobalAdvisorAdapterRegistry.getInstance();
    private boolean freezeProxy = false;
    private transient ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private transient BeanFactory beanFactory;
    private boolean advisorChainInitialized = false;
    private Object singletonInstance;

    public void setProxyInterfaces(Class[] proxyInterfaces) throws ClassNotFoundException {
        this.setInterfaces(proxyInterfaces);
    }

    public void setInterceptorNames(String[] interceptorNames) {
        this.interceptorNames = interceptorNames;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public void setAutodetectInterfaces(boolean autodetectInterfaces) {
        this.autodetectInterfaces = autodetectInterfaces;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public void setAdvisorAdapterRegistry(AdvisorAdapterRegistry advisorAdapterRegistry) {
        this.advisorAdapterRegistry = advisorAdapterRegistry;
    }

    public void setFrozen(boolean frozen) {
        this.freezeProxy = frozen;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
        this.checkInterceptorNames();
    }

    public Object getObject() throws BeansException {
        this.initializeAdvisorChain();
        if (this.isSingleton()) {
            return this.getSingletonInstance();
        }
        if (this.targetName == null) {
            this.logger.warn((Object)"Using non-singleton proxies with singleton targets is often undesirable. Enable prototype proxies by setting the 'targetName' property.");
        }
        return this.newPrototypeInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class getObjectType() {
        ProxyFactoryBean proxyFactoryBean = this;
        synchronized (proxyFactoryBean) {
            if (this.singletonInstance != null) {
                return this.singletonInstance.getClass();
            }
        }
        Class[] ifcs = this.getProxiedInterfaces();
        if (ifcs.length == 1) {
            return ifcs[0];
        }
        if (ifcs.length > 1) {
            return this.createCompositeInterface(ifcs);
        }
        if (this.targetName != null && this.beanFactory != null) {
            return this.beanFactory.getType(this.targetName);
        }
        return this.getTargetClass();
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    protected Class createCompositeInterface(Class[] interfaces) {
        return ClassUtils.createCompositeInterface(interfaces, this.beanClassLoader);
    }

    private synchronized Object getSingletonInstance() {
        if (this.singletonInstance == null) {
            this.targetSource = this.freshTargetSource();
            if (this.autodetectInterfaces && this.getProxiedInterfaces().length == 0 && !this.isProxyTargetClass()) {
                Class targetClass = this.getTargetClass();
                if (targetClass == null) {
                    throw new FactoryBeanNotInitializedException("Cannot determine target class for proxy");
                }
                this.setInterfaces(ClassUtils.getAllInterfacesForClass(targetClass, this.beanClassLoader));
            }
            super.setFrozen(this.freezeProxy);
            this.singletonInstance = this.getProxy(this.createAopProxy());
        }
        return this.singletonInstance;
    }

    private synchronized Object newPrototypeInstance() {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Creating copy of prototype ProxyFactoryBean config: " + this));
        }
        ProxyCreatorSupport copy = new ProxyCreatorSupport(this.getAopProxyFactory());
        TargetSource targetSource = this.freshTargetSource();
        copy.copyConfigurationFrom(this, targetSource, this.freshAdvisorChain());
        if (this.autodetectInterfaces && this.getProxiedInterfaces().length == 0 && !this.isProxyTargetClass()) {
            copy.setInterfaces(ClassUtils.getAllInterfacesForClass(targetSource.getTargetClass(), this.beanClassLoader));
        }
        copy.setFrozen(this.freezeProxy);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Using ProxyCreatorSupport copy: " + copy));
        }
        return this.getProxy(copy.createAopProxy());
    }

    protected Object getProxy(AopProxy aopProxy) {
        return aopProxy.getProxy(this.beanClassLoader);
    }

    private void checkInterceptorNames() {
        if (!ObjectUtils.isEmpty(this.interceptorNames)) {
            String finalName = this.interceptorNames[this.interceptorNames.length - 1];
            if (this.targetName == null && this.targetSource == EMPTY_TARGET_SOURCE && !finalName.endsWith(GLOBAL_SUFFIX) && !this.isNamedBeanAnAdvisorOrAdvice(finalName)) {
                this.targetName = finalName;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Bean with name '" + finalName + "' concluding interceptor chain " + "is not an advisor class: treating it as a target or TargetSource"));
                }
                String[] newNames = new String[this.interceptorNames.length - 1];
                System.arraycopy(this.interceptorNames, 0, newNames, 0, newNames.length);
                this.interceptorNames = newNames;
            }
        }
    }

    private boolean isNamedBeanAnAdvisorOrAdvice(String beanName) {
        Class namedBeanClass = this.beanFactory.getType(beanName);
        if (namedBeanClass != null) {
            return Advisor.class.isAssignableFrom(namedBeanClass) || Advice.class.isAssignableFrom(namedBeanClass);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Could not determine type of bean with name '" + beanName + "' - assuming it is neither an Advisor nor an Advice"));
        }
        return false;
    }

    private synchronized void initializeAdvisorChain() throws AopConfigException, BeansException {
        if (this.advisorChainInitialized) {
            return;
        }
        if (!ObjectUtils.isEmpty(this.interceptorNames)) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("No BeanFactory available anymore (probably due to serialization) - cannot resolve interceptor names " + Arrays.asList(this.interceptorNames));
            }
            if (this.interceptorNames[this.interceptorNames.length - 1].endsWith(GLOBAL_SUFFIX) && this.targetName == null && this.targetSource == EMPTY_TARGET_SOURCE) {
                throw new AopConfigException("Target required after globals");
            }
            for (int i = 0; i < this.interceptorNames.length; ++i) {
                String name = this.interceptorNames[i];
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Configuring advisor or advice '" + name + "'"));
                }
                if (name.endsWith(GLOBAL_SUFFIX)) {
                    if (!(this.beanFactory instanceof ListableBeanFactory)) {
                        throw new AopConfigException("Can only use global advisors or interceptors with a ListableBeanFactory");
                    }
                    this.addGlobalAdvisor((ListableBeanFactory)this.beanFactory, name.substring(0, name.length() - GLOBAL_SUFFIX.length()));
                    continue;
                }
                Object advice = null;
                advice = this.singleton || this.beanFactory.isSingleton(this.interceptorNames[i]) ? this.beanFactory.getBean(this.interceptorNames[i]) : new PrototypePlaceholderAdvisor(this.interceptorNames[i]);
                this.addAdvisorOnChainCreation(advice, this.interceptorNames[i]);
            }
        }
        this.advisorChainInitialized = true;
    }

    private List freshAdvisorChain() {
        Advisor[] advisors = this.getAdvisors();
        ArrayList<Advisor> freshAdvisors = new ArrayList<Advisor>(advisors.length);
        for (int i = 0; i < advisors.length; ++i) {
            if (advisors[i] instanceof PrototypePlaceholderAdvisor) {
                PrototypePlaceholderAdvisor pa = (PrototypePlaceholderAdvisor)advisors[i];
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Refreshing bean named '" + pa.getBeanName() + "'"));
                }
                if (this.beanFactory == null) {
                    throw new IllegalStateException("No BeanFactory available anymore (probably due to serialization) - cannot resolve prototype advisor '" + pa.getBeanName() + "'");
                }
                Object bean = this.beanFactory.getBean(pa.getBeanName());
                Advisor refreshedAdvisor = this.namedBeanToAdvisor(bean);
                freshAdvisors.add(refreshedAdvisor);
                continue;
            }
            freshAdvisors.add(advisors[i]);
        }
        return freshAdvisors;
    }

    private void addGlobalAdvisor(ListableBeanFactory beanFactory, String prefix) {
        Object bean;
        String name;
        int i;
        String[] globalAdvisorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, Advisor.class);
        String[] globalInterceptorNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors(beanFactory, Interceptor.class);
        ArrayList<Object> beans = new ArrayList<Object>(globalAdvisorNames.length + globalInterceptorNames.length);
        HashMap<Object, String> names = new HashMap<Object, String>();
        for (i = 0; i < globalAdvisorNames.length; ++i) {
            name = globalAdvisorNames[i];
            bean = beanFactory.getBean(name);
            beans.add(bean);
            names.put(bean, name);
        }
        for (i = 0; i < globalInterceptorNames.length; ++i) {
            name = globalInterceptorNames[i];
            bean = beanFactory.getBean(name);
            beans.add(bean);
            names.put(bean, name);
        }
        Collections.sort(beans, new OrderComparator());
        Iterator it = beans.iterator();
        while (it.hasNext()) {
            Object bean2 = it.next();
            String name2 = (String)names.get(bean2);
            if (!name2.startsWith(prefix)) continue;
            this.addAdvisorOnChainCreation(bean2, name2);
        }
    }

    private void addAdvisorOnChainCreation(Object next, String name) {
        Advisor advisor = this.namedBeanToAdvisor(next);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("Adding advisor with name '" + name + "'"));
        }
        this.addAdvisor(advisor);
    }

    private TargetSource freshTargetSource() {
        Object target;
        if (this.targetName == null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)"Not refreshing target: Bean name not specified in 'interceptorNames'.");
            }
            return this.targetSource;
        }
        if (this.beanFactory == null) {
            throw new IllegalStateException("No BeanFactory available anymore (probably due to serialization) - cannot resolve target with name '" + this.targetName + "'");
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Refreshing target with name '" + this.targetName + "'"));
        }
        return (target = this.beanFactory.getBean(this.targetName)) instanceof TargetSource ? (TargetSource)target : new SingletonTargetSource(target);
    }

    private Advisor namedBeanToAdvisor(Object next) {
        try {
            return this.advisorAdapterRegistry.wrap(next);
        }
        catch (UnknownAdviceTypeException ex) {
            throw new AopConfigException("Unknown advisor type " + next.getClass() + "; Can only include Advisor or Advice type beans in interceptorNames chain except for last entry," + "which may also be target or TargetSource", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adviceChanged() {
        super.adviceChanged();
        if (this.singleton) {
            this.logger.debug((Object)"Advice has changed; recaching singleton instance");
            ProxyFactoryBean proxyFactoryBean = this;
            synchronized (proxyFactoryBean) {
                this.singletonInstance = null;
            }
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.beanClassLoader = ClassUtils.getDefaultClassLoader();
    }

    private static class PrototypePlaceholderAdvisor
    implements Advisor,
    Serializable {
        private final String beanName;
        private final String message;

        public PrototypePlaceholderAdvisor(String beanName) {
            this.beanName = beanName;
            this.message = "Placeholder for prototype Advisor/Advice with bean name '" + beanName + "'";
        }

        public String getBeanName() {
            return this.beanName;
        }

        public Advice getAdvice() {
            throw new UnsupportedOperationException("Cannot invoke methods: " + this.message);
        }

        public boolean isPerInstance() {
            throw new UnsupportedOperationException("Cannot invoke methods: " + this.message);
        }

        public String toString() {
            return this.message;
        }
    }
}

