/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.framework.autoproxy.target;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.aop.TargetSource;
import com.bea.core.repackaged.springframework.aop.framework.AopInfrastructureBean;
import com.bea.core.repackaged.springframework.aop.framework.autoproxy.TargetSourceCreator;
import com.bea.core.repackaged.springframework.aop.target.AbstractBeanFactoryBasedTargetSource;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryAware;
import com.bea.core.repackaged.springframework.beans.factory.DisposableBean;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanPostProcessor;
import com.bea.core.repackaged.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.support.DefaultListableBeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.support.GenericBeanDefinition;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class AbstractBeanFactoryBasedTargetSourceCreator
implements TargetSourceCreator,
BeanFactoryAware,
DisposableBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private ConfigurableBeanFactory beanFactory;
    private final Map internalBeanFactories = new HashMap();

    public final void setBeanFactory(BeanFactory beanFactory) {
        if (!(beanFactory instanceof ConfigurableBeanFactory)) {
            throw new IllegalStateException("Cannot do auto-TargetSource creation with a BeanFactory that doesn't implement ConfigurableBeanFactory: " + beanFactory.getClass());
        }
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    protected final BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public final TargetSource getTargetSource(Class beanClass, String beanName) {
        AbstractBeanFactoryBasedTargetSource targetSource = this.createBeanFactoryBasedTargetSource(beanClass, beanName);
        if (targetSource == null) {
            return null;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Configuring AbstractBeanFactoryBasedTargetSource: " + targetSource));
        }
        DefaultListableBeanFactory internalBeanFactory = this.getInternalBeanFactoryForBean(beanName);
        BeanDefinition bd = this.beanFactory.getMergedBeanDefinition(beanName);
        GenericBeanDefinition bdCopy = new GenericBeanDefinition(bd);
        if (this.isPrototypeBased()) {
            bdCopy.setScope("prototype");
        }
        internalBeanFactory.registerBeanDefinition(beanName, bdCopy);
        targetSource.setTargetBeanName(beanName);
        targetSource.setBeanFactory(internalBeanFactory);
        return targetSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DefaultListableBeanFactory getInternalBeanFactoryForBean(String beanName) {
        DefaultListableBeanFactory internalBeanFactory = null;
        Map map = this.internalBeanFactories;
        synchronized (map) {
            internalBeanFactory = (DefaultListableBeanFactory)this.internalBeanFactories.get(beanName);
            if (internalBeanFactory == null) {
                internalBeanFactory = this.buildInternalBeanFactory(this.beanFactory);
                this.internalBeanFactories.put(beanName, internalBeanFactory);
            }
        }
        return internalBeanFactory;
    }

    protected DefaultListableBeanFactory buildInternalBeanFactory(ConfigurableBeanFactory containingFactory) {
        DefaultListableBeanFactory internalBeanFactory = new DefaultListableBeanFactory(containingFactory);
        internalBeanFactory.copyConfigurationFrom(containingFactory);
        Iterator it = internalBeanFactory.getBeanPostProcessors().iterator();
        while (it.hasNext()) {
            BeanPostProcessor postProcessor = (BeanPostProcessor)it.next();
            if (!(postProcessor instanceof AopInfrastructureBean)) continue;
            it.remove();
        }
        return internalBeanFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Map map = this.internalBeanFactories;
        synchronized (map) {
            Iterator it = this.internalBeanFactories.values().iterator();
            while (it.hasNext()) {
                ((DefaultListableBeanFactory)it.next()).destroySingletons();
            }
        }
    }

    protected boolean isPrototypeBased() {
        return true;
    }

    protected abstract AbstractBeanFactoryBasedTargetSource createBeanFactoryBasedTargetSource(Class var1, String var2);
}

