/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.scope;

import com.bea.core.repackaged.springframework.aop.scope.ScopedObject;
import com.bea.core.repackaged.springframework.beans.factory.config.ConfigurableBeanFactory;
import com.bea.core.repackaged.springframework.util.Assert;

public class DefaultScopedObject
implements ScopedObject {
    private final ConfigurableBeanFactory beanFactory;
    private final String targetBeanName;

    public DefaultScopedObject(ConfigurableBeanFactory beanFactory, String targetBeanName) {
        Assert.notNull(beanFactory, "BeanFactory must not be null");
        Assert.hasText(targetBeanName, "'targetBeanName' must not be empty");
        this.beanFactory = beanFactory;
        this.targetBeanName = targetBeanName;
    }

    public Object getTargetObject() {
        return this.beanFactory.getBean(this.targetBeanName);
    }

    public void removeFromScope() {
        this.beanFactory.destroyScopedBean(this.targetBeanName);
    }
}

