/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.support;

import com.bea.core.repackaged.springframework.aop.ClassFilter;
import com.bea.core.repackaged.springframework.aop.MethodMatcher;
import com.bea.core.repackaged.springframework.aop.Pointcut;
import com.bea.core.repackaged.springframework.core.ControlFlow;
import com.bea.core.repackaged.springframework.core.ControlFlowFactory;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import java.io.Serializable;
import java.lang.reflect.Method;

public class ControlFlowPointcut
implements Pointcut,
ClassFilter,
MethodMatcher,
Serializable {
    private Class clazz;
    private String methodName;
    private int evaluations;

    public ControlFlowPointcut(Class clazz) {
        this(clazz, null);
    }

    public ControlFlowPointcut(Class clazz, String methodName) {
        Assert.notNull(clazz, "Class must not be null");
        this.clazz = clazz;
        this.methodName = methodName;
    }

    public boolean matches(Class clazz) {
        return true;
    }

    public boolean matches(Method method, Class targetClass) {
        return true;
    }

    public boolean isRuntime() {
        return true;
    }

    public boolean matches(Method method, Class targetClass, Object[] args) {
        ++this.evaluations;
        ControlFlow cflow = ControlFlowFactory.createControlFlow();
        return this.methodName != null ? cflow.under(this.clazz, this.methodName) : cflow.under(this.clazz);
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    public ClassFilter getClassFilter() {
        return this;
    }

    public MethodMatcher getMethodMatcher() {
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ControlFlowPointcut)) {
            return false;
        }
        ControlFlowPointcut that = (ControlFlowPointcut)other;
        return this.clazz.equals(that.clazz) && ObjectUtils.nullSafeEquals(that.methodName, this.methodName);
    }

    public int hashCode() {
        int code = 17;
        code = 37 * code + this.clazz.hashCode();
        if (this.methodName != null) {
            code = 37 * code + this.methodName.hashCode();
        }
        return code;
    }
}

