/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.aop.target;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.aop.TargetSource;
import com.bea.core.repackaged.springframework.aop.target.SingletonTargetSource;
import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactory;
import com.bea.core.repackaged.springframework.beans.factory.BeanFactoryAware;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;

public abstract class AbstractBeanFactoryBasedTargetSource
implements TargetSource,
BeanFactoryAware,
Serializable {
    private static final long serialVersionUID = -4721607536018568393L;
    protected final Log logger = LogFactory.getLog(this.getClass());
    private String targetBeanName;
    private Class targetClass;
    private BeanFactory beanFactory;

    public void setTargetBeanName(String targetBeanName) {
        this.targetBeanName = targetBeanName;
    }

    public String getTargetBeanName() {
        return this.targetBeanName;
    }

    public void setTargetClass(Class targetClass) {
        this.targetClass = targetClass;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (this.targetBeanName == null) {
            throw new IllegalStateException("Property'targetBeanName' is required");
        }
        this.beanFactory = beanFactory;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public synchronized Class getTargetClass() {
        if (this.targetClass == null && this.beanFactory != null) {
            this.targetClass = this.beanFactory.getType(this.targetBeanName);
            if (this.targetClass == null) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("Getting bean with name '" + this.targetBeanName + "' in order to determine type"));
                }
                this.targetClass = this.beanFactory.getBean(this.targetBeanName).getClass();
            }
        }
        return this.targetClass;
    }

    public boolean isStatic() {
        return false;
    }

    public void releaseTarget(Object target) throws Exception {
    }

    protected void copyFrom(AbstractBeanFactoryBasedTargetSource other) {
        this.targetBeanName = other.targetBeanName;
        this.targetClass = other.targetClass;
        this.beanFactory = other.beanFactory;
    }

    protected Object writeReplace() throws ObjectStreamException {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Disconnecting TargetSource [" + this + "]"));
        }
        try {
            return new SingletonTargetSource(this.getTarget());
        }
        catch (Exception ex) {
            this.logger.error((Object)("Cannot get target for disconnecting TargetSource [" + this + "]"), (Throwable)ex);
            throw new NotSerializableException("Cannot get target for disconnecting TargetSource [" + this + "]: " + ex);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        AbstractBeanFactoryBasedTargetSource otherTargetSource = (AbstractBeanFactoryBasedTargetSource)other;
        return ObjectUtils.nullSafeEquals(this.beanFactory, otherTargetSource.beanFactory) && ObjectUtils.nullSafeEquals(this.targetBeanName, otherTargetSource.targetBeanName);
    }

    public int hashCode() {
        int hashCode = this.getClass().hashCode();
        hashCode = 13 * hashCode + ObjectUtils.nullSafeHashCode(this.beanFactory);
        hashCode = 13 * hashCode + ObjectUtils.nullSafeHashCode(this.targetBeanName);
        return hashCode;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(ClassUtils.getShortName(this.getClass()));
        sb.append(" for target bean '").append(this.targetBeanName).append("'");
        if (this.targetClass != null) {
            sb.append(" of type [").append(this.targetClass.getName()).append("]");
        }
        return sb.toString();
    }
}

