/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans;

import com.bea.core.repackaged.springframework.beans.AbstractPropertyAccessor;
import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.InvalidPropertyException;
import com.bea.core.repackaged.springframework.beans.NotReadablePropertyException;
import com.bea.core.repackaged.springframework.beans.NotWritablePropertyException;
import com.bea.core.repackaged.springframework.beans.TypeConverterDelegate;
import com.bea.core.repackaged.springframework.beans.TypeMismatchException;
import com.bea.core.repackaged.springframework.core.MethodParameter;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ReflectionUtils;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public class DirectFieldAccessor
extends AbstractPropertyAccessor {
    private final Object target;
    private final Map fieldMap = new HashMap();
    private final TypeConverterDelegate typeConverterDelegate;

    public DirectFieldAccessor(Object target) {
        Assert.notNull(target, "Target object must not be null");
        this.target = target;
        ReflectionUtils.doWithFields(this.target.getClass(), new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                DirectFieldAccessor.this.fieldMap.put(field.getName(), field);
            }
        });
        this.typeConverterDelegate = new TypeConverterDelegate(this, target);
        this.setExtractOldValueForEditor(true);
    }

    public boolean isReadableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    public boolean isWritableProperty(String propertyName) throws BeansException {
        return this.fieldMap.containsKey(propertyName);
    }

    public Class getPropertyType(String propertyName) throws BeansException {
        Field field = (Field)this.fieldMap.get(propertyName);
        if (field != null) {
            return field.getType();
        }
        return null;
    }

    public Object getPropertyValue(String propertyName) throws BeansException {
        Field field = (Field)this.fieldMap.get(propertyName);
        if (field == null) {
            throw new NotReadablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        try {
            ReflectionUtils.makeAccessible(field);
            return field.get(this.target);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex);
        }
    }

    public void setPropertyValue(String propertyName, Object newValue) throws BeansException {
        Field field = (Field)this.fieldMap.get(propertyName);
        if (field == null) {
            throw new NotWritablePropertyException(this.target.getClass(), propertyName, "Field '" + propertyName + "' does not exist");
        }
        Object oldValue = null;
        try {
            ReflectionUtils.makeAccessible(field);
            oldValue = field.get(this.target);
            Object convertedValue = this.typeConverterDelegate.convertIfNecessary(propertyName, oldValue, newValue, field.getType());
            field.set(this.target, convertedValue);
        }
        catch (IllegalAccessException ex) {
            throw new InvalidPropertyException(this.target.getClass(), propertyName, "Field is not accessible", ex);
        }
        catch (IllegalArgumentException ex) {
            PropertyChangeEvent pce = new PropertyChangeEvent(this.target, propertyName, oldValue, newValue);
            throw new TypeMismatchException(pce, field.getType(), (Throwable)ex);
        }
    }

    public Object convertIfNecessary(Object value, Class requiredType, MethodParameter methodParam) throws TypeMismatchException {
        try {
            return this.typeConverterDelegate.convertIfNecessary(value, requiredType, methodParam);
        }
        catch (IllegalArgumentException ex) {
            throw new TypeMismatchException(value, requiredType, (Throwable)ex);
        }
    }
}

