/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory;

import com.bea.core.repackaged.springframework.beans.FatalBeanException;
import com.bea.core.repackaged.springframework.core.NestedRuntimeException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class BeanCreationException
extends FatalBeanException {
    private String beanName;
    private String resourceDescription;
    private List relatedCauses;

    public BeanCreationException(String msg) {
        super(msg);
    }

    public BeanCreationException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public BeanCreationException(String beanName, String msg) {
        this(beanName, msg, (Throwable)null);
    }

    public BeanCreationException(String beanName, String msg, Throwable cause) {
        super("Error creating bean with name '" + beanName + "': " + msg, cause);
        this.beanName = beanName;
    }

    public BeanCreationException(String resourceDescription, String beanName, String msg) {
        this(resourceDescription, beanName, msg, null);
    }

    public BeanCreationException(String resourceDescription, String beanName, String msg, Throwable cause) {
        super("Error creating bean with name '" + beanName + "'" + (resourceDescription != null ? " defined in " + resourceDescription : "") + ": " + msg, cause);
        this.resourceDescription = resourceDescription;
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getResourceDescription() {
        return this.resourceDescription;
    }

    public void addRelatedCause(Throwable ex) {
        if (this.relatedCauses == null) {
            this.relatedCauses = new LinkedList();
        }
        this.relatedCauses.add(ex);
    }

    public Throwable[] getRelatedCauses() {
        if (this.relatedCauses == null) {
            return null;
        }
        return this.relatedCauses.toArray(new Throwable[this.relatedCauses.size()]);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        if (this.relatedCauses != null) {
            Iterator it = this.relatedCauses.iterator();
            while (it.hasNext()) {
                Throwable relatedCause = (Throwable)it.next();
                sb.append("\nRelated cause: ");
                sb.append(relatedCause);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream ps) {
        PrintStream printStream = ps;
        synchronized (printStream) {
            super.printStackTrace(ps);
            if (this.relatedCauses != null) {
                Iterator it = this.relatedCauses.iterator();
                while (it.hasNext()) {
                    Throwable relatedCause = (Throwable)it.next();
                    ps.println("Related cause:");
                    relatedCause.printStackTrace(ps);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter pw) {
        PrintWriter printWriter = pw;
        synchronized (printWriter) {
            super.printStackTrace(pw);
            if (this.relatedCauses != null) {
                Iterator it = this.relatedCauses.iterator();
                while (it.hasNext()) {
                    Throwable relatedCause = (Throwable)it.next();
                    pw.println("Related cause:");
                    relatedCause.printStackTrace(pw);
                }
            }
        }
    }

    public boolean contains(Class exClass) {
        if (super.contains(exClass)) {
            return true;
        }
        if (this.relatedCauses != null) {
            Iterator it = this.relatedCauses.iterator();
            while (it.hasNext()) {
                Throwable relatedCause = (Throwable)it.next();
                if (!(relatedCause instanceof NestedRuntimeException) || !((NestedRuntimeException)relatedCause).contains(exClass)) continue;
                return true;
            }
        }
        return false;
    }
}

