/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.config;

import com.bea.core.repackaged.springframework.beans.BeanUtils;
import com.bea.core.repackaged.springframework.beans.TypeConverter;
import com.bea.core.repackaged.springframework.beans.factory.config.AbstractFactoryBean;
import com.bea.core.repackaged.springframework.core.GenericCollectionTypeResolver;
import com.bea.core.repackaged.springframework.core.JdkVersion;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ListFactoryBean
extends AbstractFactoryBean {
    private List sourceList;
    private Class targetListClass;

    public void setSourceList(List sourceList) {
        this.sourceList = sourceList;
    }

    public void setTargetListClass(Class targetListClass) {
        if (targetListClass == null) {
            throw new IllegalArgumentException("'targetListClass' must not be null");
        }
        if (!List.class.isAssignableFrom(targetListClass)) {
            throw new IllegalArgumentException("'targetListClass' must implement [java.util.List]");
        }
        this.targetListClass = targetListClass;
    }

    public Class getObjectType() {
        return List.class;
    }

    protected Object createInstance() {
        if (this.sourceList == null) {
            throw new IllegalArgumentException("'sourceList' is required");
        }
        ArrayList<Object> result = null;
        result = this.targetListClass != null ? (ArrayList<Object>)BeanUtils.instantiateClass(this.targetListClass) : new ArrayList<Object>(this.sourceList.size());
        Class valueType = null;
        if (this.targetListClass != null && JdkVersion.isAtLeastJava15()) {
            valueType = GenericCollectionTypeResolver.getCollectionType(this.targetListClass);
        }
        if (valueType != null) {
            TypeConverter converter = this.getBeanTypeConverter();
            Iterator it = this.sourceList.iterator();
            while (it.hasNext()) {
                result.add(converter.convertIfNecessary(it.next(), valueType));
            }
        } else {
            result.addAll(this.sourceList);
        }
        return result;
    }
}

