/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.support;

import com.bea.core.repackaged.springframework.beans.factory.support.MethodOverride;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ObjectUtils;
import java.lang.reflect.Method;

public class LookupOverride
extends MethodOverride {
    private final String beanName;

    public LookupOverride(String methodName, String beanName) {
        super(methodName);
        Assert.notNull(beanName, "Bean name must not be null");
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public boolean matches(Method method) {
        return method.getName().equals(this.getMethodName()) && method.getParameterTypes().length == 0;
    }

    public String toString() {
        return "LookupOverride for method '" + this.getMethodName() + "'; will return bean '" + this.beanName + "'";
    }

    public boolean equals(Object other) {
        return other instanceof LookupOverride && super.equals(other) && ObjectUtils.nullSafeEquals(this.beanName, ((LookupOverride)other).beanName);
    }

    public int hashCode() {
        return 29 * super.hashCode() + ObjectUtils.nullSafeHashCode(this.beanName);
    }
}

