/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.xml;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.FatalBeanException;
import com.bea.core.repackaged.springframework.core.io.ClassPathResource;
import com.bea.core.repackaged.springframework.core.io.support.PropertiesLoaderUtils;
import com.bea.core.repackaged.springframework.util.Assert;
import java.io.IOException;
import java.util.Properties;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class PluggableSchemaResolver
implements EntityResolver {
    public static final String DEFAULT_SCHEMA_MAPPINGS_LOCATION = "META-INF/bea-spring.schemas";
    private static final Log logger = LogFactory.getLog(PluggableSchemaResolver.class);
    private final ClassLoader classLoader;
    private final String schemaMappingsLocation;
    private Properties schemaMappings;

    public PluggableSchemaResolver(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.schemaMappingsLocation = DEFAULT_SCHEMA_MAPPINGS_LOCATION;
    }

    public PluggableSchemaResolver(ClassLoader classLoader, String string) {
        Assert.hasText(string, "'schemaMappingsLocation' must not be empty");
        this.classLoader = classLoader;
        this.schemaMappingsLocation = string;
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws IOException {
        String string3;
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Trying to resolve XML entity with public id [" + string + "] and system id [" + string2 + "]"));
        }
        if (string2 != null && (string3 = this.getSchemaMapping(string2)) != null) {
            ClassPathResource classPathResource = new ClassPathResource(string3, this.classLoader);
            InputSource inputSource = new InputSource(classPathResource.getInputStream());
            inputSource.setPublicId(string);
            inputSource.setSystemId(string2);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found XML schema [" + string2 + "] in classpath: " + string3));
            }
            return inputSource;
        }
        return null;
    }

    protected String getSchemaMapping(String string) {
        if (this.schemaMappings == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Loading schema mappings from [" + this.schemaMappingsLocation + "]"));
            }
            try {
                this.schemaMappings = PropertiesLoaderUtils.loadAllProperties(this.schemaMappingsLocation, this.classLoader);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Loaded schema mappings: " + this.schemaMappings));
                }
            }
            catch (IOException iOException) {
                throw new FatalBeanException("Unable to load schema mappings from location [" + this.schemaMappingsLocation + "]", iOException);
            }
        }
        return this.schemaMappings.getProperty(string);
    }
}

