/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.factory.xml;

import com.bea.core.repackaged.springframework.beans.BeanUtils;
import com.bea.core.repackaged.springframework.beans.factory.BeanDefinitionStoreException;
import com.bea.core.repackaged.springframework.beans.factory.parsing.EmptyReaderEventListener;
import com.bea.core.repackaged.springframework.beans.factory.parsing.FailFastProblemReporter;
import com.bea.core.repackaged.springframework.beans.factory.parsing.NullSourceExtractor;
import com.bea.core.repackaged.springframework.beans.factory.parsing.ProblemReporter;
import com.bea.core.repackaged.springframework.beans.factory.parsing.ReaderEventListener;
import com.bea.core.repackaged.springframework.beans.factory.parsing.SourceExtractor;
import com.bea.core.repackaged.springframework.beans.factory.support.AbstractBeanDefinitionReader;
import com.bea.core.repackaged.springframework.beans.factory.support.BeanDefinitionRegistry;
import com.bea.core.repackaged.springframework.beans.factory.xml.BeanDefinitionDocumentReader;
import com.bea.core.repackaged.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import com.bea.core.repackaged.springframework.beans.factory.xml.DefaultDocumentLoader;
import com.bea.core.repackaged.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import com.bea.core.repackaged.springframework.beans.factory.xml.DelegatingEntityResolver;
import com.bea.core.repackaged.springframework.beans.factory.xml.DocumentLoader;
import com.bea.core.repackaged.springframework.beans.factory.xml.NamespaceHandlerResolver;
import com.bea.core.repackaged.springframework.beans.factory.xml.ResourceEntityResolver;
import com.bea.core.repackaged.springframework.beans.factory.xml.XmlBeanDefinitionParser;
import com.bea.core.repackaged.springframework.beans.factory.xml.XmlBeanDefinitionStoreException;
import com.bea.core.repackaged.springframework.beans.factory.xml.XmlReaderContext;
import com.bea.core.repackaged.springframework.core.Constants;
import com.bea.core.repackaged.springframework.core.NamedThreadLocal;
import com.bea.core.repackaged.springframework.core.io.DescriptiveResource;
import com.bea.core.repackaged.springframework.core.io.Resource;
import com.bea.core.repackaged.springframework.core.io.ResourceLoader;
import com.bea.core.repackaged.springframework.core.io.support.EncodedResource;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.xml.SimpleSaxErrorHandler;
import com.bea.core.repackaged.springframework.util.xml.XmlValidationModeDetector;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XmlBeanDefinitionReader
extends AbstractBeanDefinitionReader {
    public static final int VALIDATION_NONE = 0;
    public static final int VALIDATION_AUTO = 1;
    public static final int VALIDATION_DTD = 2;
    public static final int VALIDATION_XSD = 3;
    private static final Constants constants = new Constants(XmlBeanDefinitionReader.class);
    private boolean namespaceAware;
    private int validationMode = 3;
    private Class parserClass;
    private Class documentReaderClass = DefaultBeanDefinitionDocumentReader.class;
    private ProblemReporter problemReporter = new FailFastProblemReporter();
    private ReaderEventListener eventListener = new EmptyReaderEventListener();
    private SourceExtractor sourceExtractor = new NullSourceExtractor();
    private NamespaceHandlerResolver namespaceHandlerResolver;
    private DocumentLoader documentLoader = new DefaultDocumentLoader();
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler = new SimpleSaxErrorHandler(this.logger);
    private final XmlValidationModeDetector validationModeDetector = new XmlValidationModeDetector();
    private final ThreadLocal resourcesCurrentlyBeingLoaded = new NamedThreadLocal("XML bean definition resources currently being loaded");

    public XmlBeanDefinitionReader(BeanDefinitionRegistry beanDefinitionRegistry) {
        super(beanDefinitionRegistry);
    }

    public void setNamespaceAware(boolean bl) {
        this.namespaceAware = bl;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public void setValidating(boolean bl) {
        this.validationMode = bl ? 1 : 0;
    }

    public void setValidationModeName(String string) {
        this.setValidationMode(constants.asNumber(string).intValue());
    }

    public void setValidationMode(int n) {
        this.validationMode = n;
    }

    public int getValidationMode() {
        return this.validationMode;
    }

    public void setProblemReporter(ProblemReporter problemReporter) {
        this.problemReporter = problemReporter != null ? problemReporter : new FailFastProblemReporter();
    }

    public void setEventListener(ReaderEventListener readerEventListener) {
        this.eventListener = readerEventListener != null ? readerEventListener : new EmptyReaderEventListener();
    }

    public void setSourceExtractor(SourceExtractor sourceExtractor) {
        this.sourceExtractor = sourceExtractor != null ? sourceExtractor : new NullSourceExtractor();
    }

    public void setNamespaceHandlerResolver(NamespaceHandlerResolver namespaceHandlerResolver) {
        this.namespaceHandlerResolver = namespaceHandlerResolver;
    }

    public void setDocumentLoader(DocumentLoader documentLoader) {
        this.documentLoader = documentLoader != null ? documentLoader : new DefaultDocumentLoader();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    protected EntityResolver getEntityResolver() {
        if (this.entityResolver == null) {
            ResourceLoader resourceLoader = this.getResourceLoader();
            this.entityResolver = resourceLoader != null ? new ResourceEntityResolver(resourceLoader) : new DelegatingEntityResolver(this.getBeanClassLoader());
        }
        return this.entityResolver;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setParserClass(Class clazz) {
        if (this.parserClass == null || !XmlBeanDefinitionParser.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("'parserClass' must be an XmlBeanDefinitionParser");
        }
        this.parserClass = clazz;
    }

    public void setDocumentReaderClass(Class clazz) {
        if (clazz == null || !BeanDefinitionDocumentReader.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("documentReaderClass must be an implementation of the BeanDefinitionDocumentReader interface");
        }
        this.documentReaderClass = clazz;
    }

    @Override
    public int loadBeanDefinitions(Resource resource) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(new EncodedResource(resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadBeanDefinitions(EncodedResource encodedResource) throws BeanDefinitionStoreException {
        HashSet<EncodedResource> hashSet;
        Assert.notNull(encodedResource, "EncodedResource must not be null");
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)("Loading XML bean definitions from " + encodedResource.getResource()));
        }
        if ((hashSet = (HashSet<EncodedResource>)this.resourcesCurrentlyBeingLoaded.get()) == null) {
            hashSet = new HashSet<EncodedResource>(4);
            this.resourcesCurrentlyBeingLoaded.set(hashSet);
        }
        if (!hashSet.add(encodedResource)) {
            throw new BeanDefinitionStoreException("Detected recursive loading of " + encodedResource + " - check your import definitions!");
        }
        try {
            int n;
            InputStream inputStream = encodedResource.getResource().getInputStream();
            try {
                InputSource inputSource = new InputSource(inputStream);
                if (encodedResource.getEncoding() != null) {
                    inputSource.setEncoding(encodedResource.getEncoding());
                }
                n = this.doLoadBeanDefinitions(inputSource, encodedResource.getResource());
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw new BeanDefinitionStoreException("IOException parsing XML document from " + encodedResource.getResource(), iOException);
                }
            }
            inputStream.close();
            return n;
        }
        finally {
            hashSet.remove(encodedResource);
            if (hashSet.isEmpty()) {
                this.resourcesCurrentlyBeingLoaded.set(null);
            }
        }
    }

    public int loadBeanDefinitions(InputSource inputSource) throws BeanDefinitionStoreException {
        return this.loadBeanDefinitions(inputSource, "resource loaded through SAX InputSource");
    }

    public int loadBeanDefinitions(InputSource inputSource, String string) throws BeanDefinitionStoreException {
        return this.doLoadBeanDefinitions(inputSource, new DescriptiveResource(string));
    }

    protected int doLoadBeanDefinitions(InputSource inputSource, Resource resource) throws BeanDefinitionStoreException {
        try {
            int n = this.getValidationModeForResource(resource);
            Document document = this.documentLoader.loadDocument(inputSource, this.getEntityResolver(), this.errorHandler, n, this.isNamespaceAware());
            return this.registerBeanDefinitions(document, resource);
        }
        catch (BeanDefinitionStoreException beanDefinitionStoreException) {
            throw beanDefinitionStoreException;
        }
        catch (SAXParseException sAXParseException) {
            throw new XmlBeanDefinitionStoreException(resource.getDescription(), "Line " + sAXParseException.getLineNumber() + " in XML document from " + resource + " is invalid", sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new XmlBeanDefinitionStoreException(resource.getDescription(), "XML document from " + resource + " is invalid", sAXException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new BeanDefinitionStoreException(resource.getDescription(), "Parser configuration exception parsing XML from " + resource, parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new BeanDefinitionStoreException(resource.getDescription(), "IOException parsing XML document from " + resource, iOException);
        }
        catch (Throwable throwable) {
            throw new BeanDefinitionStoreException(resource.getDescription(), "Unexpected exception parsing XML document from " + resource, throwable);
        }
    }

    protected int getValidationModeForResource(Resource resource) {
        int n = this.getValidationMode();
        if (n != 1) {
            return n;
        }
        int n2 = this.detectValidationMode(resource);
        if (n2 != 1) {
            return n2;
        }
        return 3;
    }

    protected int detectValidationMode(Resource resource) {
        InputStream inputStream;
        if (resource.isOpen()) {
            throw new BeanDefinitionStoreException("Passed-in Resource [" + resource + "] contains an open stream: " + "cannot determine validation mode automatically. Either pass in a Resource " + "that is able to create fresh streams, or explicitly specify the validationMode " + "on your XmlBeanDefinitionReader instance.");
        }
        try {
            inputStream = resource.getInputStream();
        }
        catch (IOException iOException) {
            throw new BeanDefinitionStoreException("Unable to determine validation mode for [" + resource + "]: cannot open InputStream. " + "Did you attempt to load directly from a SAX InputSource without specifying the " + "validationMode on your XmlBeanDefinitionReader instance?", iOException);
        }
        try {
            return this.validationModeDetector.detectValidationMode(inputStream);
        }
        catch (IOException iOException) {
            throw new BeanDefinitionStoreException("Unable to determine validation mode for [" + resource + "]: an error occurred whilst reading from the InputStream.", iOException);
        }
    }

    public int registerBeanDefinitions(Document document, Resource resource) throws BeanDefinitionStoreException {
        if (this.parserClass != null) {
            XmlBeanDefinitionParser xmlBeanDefinitionParser = (XmlBeanDefinitionParser)BeanUtils.instantiateClass(this.parserClass);
            return xmlBeanDefinitionParser.registerBeanDefinitions(this, document, resource);
        }
        BeanDefinitionDocumentReader beanDefinitionDocumentReader = this.createBeanDefinitionDocumentReader();
        int n = this.getRegistry().getBeanDefinitionCount();
        beanDefinitionDocumentReader.registerBeanDefinitions(document, this.createReaderContext(resource));
        return this.getRegistry().getBeanDefinitionCount() - n;
    }

    protected BeanDefinitionDocumentReader createBeanDefinitionDocumentReader() {
        return (BeanDefinitionDocumentReader)BeanUtils.instantiateClass(this.documentReaderClass);
    }

    protected XmlReaderContext createReaderContext(Resource resource) {
        if (this.namespaceHandlerResolver == null) {
            this.namespaceHandlerResolver = this.createDefaultNamespaceHandlerResolver();
        }
        return new XmlReaderContext(resource, this.problemReporter, this.eventListener, this.sourceExtractor, this, this.namespaceHandlerResolver);
    }

    protected NamespaceHandlerResolver createDefaultNamespaceHandlerResolver() {
        return new DefaultNamespaceHandlerResolver(this.getResourceLoader().getClassLoader());
    }
}

