/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.propertyeditors;

import com.bea.core.repackaged.springframework.core.io.Resource;
import com.bea.core.repackaged.springframework.core.io.ResourceEditor;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.ResourceUtils;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;

public class FileEditor
extends PropertyEditorSupport {
    private final ResourceEditor resourceEditor;

    public FileEditor() {
        this.resourceEditor = new ResourceEditor();
    }

    public FileEditor(ResourceEditor resourceEditor) {
        Assert.notNull(resourceEditor, "ResourceEditor must not be null");
        this.resourceEditor = resourceEditor;
    }

    public void setAsText(String text) throws IllegalArgumentException {
        File file;
        if (StringUtils.hasText(text) && !ResourceUtils.isUrl(text) && (file = new File(text)).isAbsolute()) {
            this.setValue(file);
            return;
        }
        this.resourceEditor.setAsText(text);
        Resource resource = (Resource)this.resourceEditor.getValue();
        if (ResourceUtils.isUrl(text) || resource.exists()) {
            try {
                this.setValue(resource != null ? resource.getFile() : null);
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("Could not retrieve File for " + resource + ": " + ex.getMessage());
            }
        } else {
            File file2 = new File(text);
            this.setValue(file2);
        }
    }

    public String getAsText() {
        File value = (File)this.getValue();
        return value != null ? value.getPath() : "";
    }
}

