/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.beans.support;

import com.bea.core.repackaged.apache.commons.logging.Log;
import com.bea.core.repackaged.apache.commons.logging.LogFactory;
import com.bea.core.repackaged.springframework.beans.BeanWrapperImpl;
import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.support.MutableSortDefinition;
import com.bea.core.repackaged.springframework.beans.support.SortDefinition;
import com.bea.core.repackaged.springframework.util.StringUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class PropertyComparator
implements Comparator {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final SortDefinition sortDefinition;
    private final BeanWrapperImpl beanWrapper = new BeanWrapperImpl(false);

    public PropertyComparator(SortDefinition sortDefinition) {
        this.sortDefinition = sortDefinition;
    }

    public PropertyComparator(String property, boolean ignoreCase, boolean ascending) {
        this.sortDefinition = new MutableSortDefinition(property, ignoreCase, ascending);
    }

    public final SortDefinition getSortDefinition() {
        return this.sortDefinition;
    }

    public int compare(Object o1, Object o2) {
        int result;
        Object v1 = this.getPropertyValue(o1);
        Object v2 = this.getPropertyValue(o2);
        if (this.sortDefinition.isIgnoreCase() && v1 instanceof String && v2 instanceof String) {
            v1 = ((String)v1).toLowerCase();
            v2 = ((String)v2).toLowerCase();
        }
        try {
            result = v1 != null ? (v2 != null ? ((Comparable)v1).compareTo(v2) : -1) : (v2 != null ? 1 : 0);
        }
        catch (RuntimeException ex) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn((Object)("Could not sort objects [" + o1 + "] and [" + o2 + "]"), (Throwable)ex);
            }
            return 0;
        }
        return this.sortDefinition.isAscending() ? result : -result;
    }

    private Object getPropertyValue(Object obj) {
        try {
            this.beanWrapper.setWrappedInstance(obj);
            return this.beanWrapper.getPropertyValue(this.sortDefinition.getProperty());
        }
        catch (BeansException ex) {
            this.logger.info((Object)"PropertyComparator could not access property - treating as null for sorting", (Throwable)ex);
            return null;
        }
    }

    public static void sort(List source, SortDefinition sortDefinition) throws BeansException {
        if (StringUtils.hasText(sortDefinition.getProperty())) {
            Collections.sort(source, new PropertyComparator(sortDefinition));
        }
    }

    public static void sort(Object[] source, SortDefinition sortDefinition) throws BeansException {
        if (StringUtils.hasText(sortDefinition.getProperty())) {
            Arrays.sort(source, new PropertyComparator(sortDefinition));
        }
    }
}

