/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.access;

import com.bea.core.repackaged.springframework.beans.BeansException;
import com.bea.core.repackaged.springframework.beans.factory.access.BeanFactoryLocator;
import com.bea.core.repackaged.springframework.beans.factory.access.BeanFactoryReference;
import com.bea.core.repackaged.springframework.beans.factory.access.BootstrapException;
import com.bea.core.repackaged.springframework.context.ApplicationContext;
import com.bea.core.repackaged.springframework.context.access.ContextBeanFactoryReference;
import com.bea.core.repackaged.springframework.context.support.ClassPathXmlApplicationContext;
import com.bea.core.repackaged.springframework.jndi.JndiLocatorSupport;
import com.bea.core.repackaged.springframework.util.StringUtils;
import javax.naming.NamingException;

public class ContextJndiBeanFactoryLocator
extends JndiLocatorSupport
implements BeanFactoryLocator {
    public static final String BEAN_FACTORY_PATH_DELIMITERS = ",; \t\n";

    public BeanFactoryReference useBeanFactory(String factoryKey) throws BeansException {
        try {
            String beanFactoryPath = (String)this.lookup(factoryKey, String.class);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("Bean factory path from JNDI environment variable [" + factoryKey + "] is: " + beanFactoryPath));
            }
            String[] paths = StringUtils.tokenizeToStringArray(beanFactoryPath, BEAN_FACTORY_PATH_DELIMITERS);
            return this.createBeanFactory(paths);
        }
        catch (NamingException ex) {
            throw new BootstrapException("Define an environment variable [" + factoryKey + "] containing " + "the class path locations of XML bean definition files", ex);
        }
    }

    protected BeanFactoryReference createBeanFactory(String[] resources) throws BeansException {
        ApplicationContext ctx = this.createApplicationContext(resources);
        return new ContextBeanFactoryReference(ctx);
    }

    protected ApplicationContext createApplicationContext(String[] resources) throws BeansException {
        return new ClassPathXmlApplicationContext(resources);
    }
}

