/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.annotation;

import com.bea.core.repackaged.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinition;
import com.bea.core.repackaged.springframework.context.annotation.Scope;
import com.bea.core.repackaged.springframework.context.annotation.ScopeMetadata;
import com.bea.core.repackaged.springframework.context.annotation.ScopeMetadataResolver;
import com.bea.core.repackaged.springframework.context.annotation.ScopedProxyMode;
import com.bea.core.repackaged.springframework.util.Assert;
import java.lang.annotation.Annotation;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationScopeMetadataResolver
implements ScopeMetadataResolver {
    private Class<? extends Annotation> scopeAnnotationType = Scope.class;
    private ScopedProxyMode scopedProxyMode;

    public AnnotationScopeMetadataResolver() {
        this(ScopedProxyMode.NO);
    }

    public AnnotationScopeMetadataResolver(ScopedProxyMode scopedProxyMode) {
        Assert.notNull((Object)scopedProxyMode, "'scopedProxyMode' cannot be null.");
        this.scopedProxyMode = scopedProxyMode;
    }

    public void setScopeAnnotationType(Class<? extends Annotation> scopeAnnotationType) {
        Assert.notNull(scopeAnnotationType, "'scopeAnnotationType' cannot be null.");
        this.scopeAnnotationType = scopeAnnotationType;
    }

    @Override
    public ScopeMetadata resolveScopeMetadata(BeanDefinition definition) {
        ScopeMetadata metadata = new ScopeMetadata();
        if (definition instanceof AnnotatedBeanDefinition) {
            AnnotatedBeanDefinition annDef = (AnnotatedBeanDefinition)definition;
            Map<String, Object> attributes = annDef.getMetadata().getAnnotationAttributes(this.scopeAnnotationType.getName());
            if (attributes != null) {
                metadata.setScopeName((String)attributes.get("value"));
            }
            if (!metadata.getScopeName().equals("singleton")) {
                metadata.setScopedProxyMode(this.scopedProxyMode);
            }
        }
        return metadata;
    }
}

