/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.config;

import com.bea.core.repackaged.springframework.beans.factory.config.BeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.xml.BeanDefinitionParser;
import com.bea.core.repackaged.springframework.beans.factory.xml.NamespaceHandlerSupport;
import com.bea.core.repackaged.springframework.beans.factory.xml.ParserContext;
import com.bea.core.repackaged.springframework.context.config.LoadTimeWeaverBeanDefinitionParser;
import com.bea.core.repackaged.springframework.context.config.MBeanExportBeanDefinitionParser;
import com.bea.core.repackaged.springframework.context.config.MBeanServerBeanDefinitionParser;
import com.bea.core.repackaged.springframework.context.config.PropertyOverrideBeanDefinitionParser;
import com.bea.core.repackaged.springframework.context.config.PropertyPlaceholderBeanDefinitionParser;
import com.bea.core.repackaged.springframework.context.config.SpringConfiguredBeanDefinitionParser;
import com.bea.core.repackaged.springframework.core.JdkVersion;
import com.bea.core.repackaged.springframework.util.ClassUtils;
import org.w3c.dom.Element;

public class ContextNamespaceHandler
extends NamespaceHandlerSupport {
    public void init() {
        this.registerBeanDefinitionParser("property-placeholder", new PropertyPlaceholderBeanDefinitionParser());
        this.registerBeanDefinitionParser("property-override", new PropertyOverrideBeanDefinitionParser());
        this.registerJava5DependentParser("annotation-config", "com.bea.core.repackaged.springframework.context.annotation.AnnotationConfigBeanDefinitionParser");
        this.registerJava5DependentParser("component-scan", "com.bea.core.repackaged.springframework.context.annotation.ComponentScanBeanDefinitionParser");
        this.registerBeanDefinitionParser("load-time-weaver", new LoadTimeWeaverBeanDefinitionParser());
        this.registerBeanDefinitionParser("spring-configured", new SpringConfiguredBeanDefinitionParser());
        this.registerBeanDefinitionParser("mbean-export", new MBeanExportBeanDefinitionParser());
        this.registerBeanDefinitionParser("mbean-server", new MBeanServerBeanDefinitionParser());
    }

    private void registerJava5DependentParser(final String elementName, final String parserClassName) {
        BeanDefinitionParser parser = null;
        if (JdkVersion.isAtLeastJava15()) {
            try {
                Class parserClass = ClassUtils.forName(parserClassName, ContextNamespaceHandler.class.getClassLoader());
                parser = (BeanDefinitionParser)parserClass.newInstance();
            }
            catch (Throwable ex) {
                throw new IllegalStateException("Unable to create Java 1.5 dependent parser: " + parserClassName, ex);
            }
        } else {
            parser = new BeanDefinitionParser(){

                public BeanDefinition parse(Element element, ParserContext parserContext) {
                    throw new IllegalStateException("Context namespace element '" + elementName + "' and its parser class [" + parserClassName + "] are only available on JDK 1.5 and higher");
                }
            };
        }
        this.registerBeanDefinitionParser(elementName, parser);
    }
}

