/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.config;

import com.bea.core.repackaged.springframework.beans.factory.support.AbstractBeanDefinition;
import com.bea.core.repackaged.springframework.beans.factory.support.BeanDefinitionBuilder;
import com.bea.core.repackaged.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import com.bea.core.repackaged.springframework.beans.factory.xml.ParserContext;
import com.bea.core.repackaged.springframework.context.config.MBeanServerBeanDefinitionParser;
import com.bea.core.repackaged.springframework.core.JdkVersion;
import com.bea.core.repackaged.springframework.util.StringUtils;
import org.w3c.dom.Element;

class MBeanExportBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    private static final String MBEAN_EXPORTER_BEAN_NAME = "mbeanExporter";
    private static final String DEFAULT_DOMAIN_ATTRIBUTE = "default-domain";
    private static final String SERVER_ATTRIBUTE = "server";
    private static final String REGISTRATION_ATTRIBUTE = "registration";
    private static final String REGISTRATION_IGNORE_EXISTING = "ignoreExisting";
    private static final String REGISTRATION_REPLACE_EXISTING = "replaceExisting";

    MBeanExportBeanDefinitionParser() {
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        return MBEAN_EXPORTER_BEAN_NAME;
    }

    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        String serverBeanName;
        String beanClassName = JdkVersion.isAtLeastJava15() ? "com.bea.core.repackaged.springframework.jmx.export.annotation.AnnotationMBeanExporter" : "com.bea.core.repackaged.springframework.jmx.export.MBeanExporter";
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(beanClassName);
        builder.setRole(2);
        String defaultDomain = element.getAttribute(DEFAULT_DOMAIN_ATTRIBUTE);
        if (StringUtils.hasText(defaultDomain)) {
            builder.addPropertyValue("defaultDomain", defaultDomain);
        }
        if (StringUtils.hasText(serverBeanName = element.getAttribute(SERVER_ATTRIBUTE))) {
            builder.addPropertyReference(SERVER_ATTRIBUTE, serverBeanName);
        } else {
            AbstractBeanDefinition specialServer = MBeanServerBeanDefinitionParser.findServerForSpecialEnvironment();
            if (specialServer != null) {
                builder.addPropertyValue(SERVER_ATTRIBUTE, specialServer);
            }
        }
        String registration = element.getAttribute(REGISTRATION_ATTRIBUTE);
        int registrationBehavior = 0;
        if (REGISTRATION_IGNORE_EXISTING.equals(registration)) {
            registrationBehavior = 1;
        } else if (REGISTRATION_REPLACE_EXISTING.equals(registration)) {
            registrationBehavior = 2;
        }
        builder.addPropertyValue("registrationBehavior", new Integer(registrationBehavior));
        return builder.getBeanDefinition();
    }
}

