/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.i18n;

import com.bea.core.repackaged.springframework.context.i18n.LocaleContext;
import com.bea.core.repackaged.springframework.context.i18n.SimpleLocaleContext;
import com.bea.core.repackaged.springframework.core.NamedInheritableThreadLocal;
import com.bea.core.repackaged.springframework.core.NamedThreadLocal;
import java.util.Locale;

public abstract class LocaleContextHolder {
    private static final ThreadLocal localeContextHolder = new NamedThreadLocal("Locale context");
    private static final ThreadLocal inheritableLocaleContextHolder = new NamedInheritableThreadLocal("Locale context");

    public static void resetLocaleContext() {
        localeContextHolder.set(null);
        inheritableLocaleContextHolder.set(null);
    }

    public static void setLocaleContext(LocaleContext localeContext) {
        LocaleContextHolder.setLocaleContext(localeContext, false);
    }

    public static void setLocaleContext(LocaleContext localeContext, boolean inheritable) {
        if (inheritable) {
            inheritableLocaleContextHolder.set(localeContext);
            localeContextHolder.set(null);
        } else {
            localeContextHolder.set(localeContext);
            inheritableLocaleContextHolder.set(null);
        }
    }

    public static LocaleContext getLocaleContext() {
        LocaleContext localeContext = (LocaleContext)localeContextHolder.get();
        if (localeContext == null) {
            localeContext = (LocaleContext)inheritableLocaleContextHolder.get();
        }
        return localeContext;
    }

    public static void setLocale(Locale locale) {
        LocaleContextHolder.setLocale(locale, false);
    }

    public static void setLocale(Locale locale, boolean inheritable) {
        SimpleLocaleContext localeContext = locale != null ? new SimpleLocaleContext(locale) : null;
        LocaleContextHolder.setLocaleContext(localeContext, inheritable);
    }

    public static Locale getLocale() {
        LocaleContext localeContext = LocaleContextHolder.getLocaleContext();
        return localeContext != null ? localeContext.getLocale() : Locale.getDefault();
    }
}

