/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.repackaged.springframework.context.support;

import com.bea.core.repackaged.springframework.beans.factory.BeanNameAware;
import com.bea.core.repackaged.springframework.beans.factory.InitializingBean;
import com.bea.core.repackaged.springframework.context.ApplicationContext;
import com.bea.core.repackaged.springframework.context.support.AbstractRefreshableApplicationContext;
import com.bea.core.repackaged.springframework.util.Assert;
import com.bea.core.repackaged.springframework.util.StringUtils;
import com.bea.core.repackaged.springframework.util.SystemPropertyUtils;

public abstract class AbstractRefreshableConfigApplicationContext
extends AbstractRefreshableApplicationContext
implements BeanNameAware,
InitializingBean {
    private String[] configLocations;
    private boolean setIdCalled = false;

    public AbstractRefreshableConfigApplicationContext() {
    }

    public AbstractRefreshableConfigApplicationContext(ApplicationContext parent) {
        super(parent);
    }

    public void setConfigLocation(String location) {
        this.setConfigLocations(StringUtils.tokenizeToStringArray(location, ",; \t\n"));
    }

    public void setConfigLocations(String[] locations) {
        if (locations != null) {
            Assert.noNullElements(locations, "Config locations must not be null");
            this.configLocations = new String[locations.length];
            for (int i = 0; i < locations.length; ++i) {
                this.configLocations[i] = this.resolvePath(locations[i]).trim();
            }
        } else {
            this.configLocations = null;
        }
    }

    protected String[] getConfigLocations() {
        return this.configLocations != null ? this.configLocations : this.getDefaultConfigLocations();
    }

    protected String[] getDefaultConfigLocations() {
        return null;
    }

    protected String resolvePath(String path) {
        return SystemPropertyUtils.resolvePlaceholders(path);
    }

    public void setId(String id) {
        super.setId(id);
        this.setIdCalled = true;
    }

    public void setBeanName(String name) {
        if (!this.setIdCalled) {
            super.setId(name);
        }
    }

    public void afterPropertiesSet() {
        if (!this.isActive()) {
            this.refresh();
        }
    }
}

